/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.ui;

import android.content.Context;
import android.content.Intent;
import android.content.res.AssetFileDescriptor;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.MediaController;
import java.io.IOException;
import org.researchstack.backbone.R;
import org.researchstack.backbone.ui.views.AssetVideoView;

public class ViewVideoActivity
extends AppCompatActivity {
    public static final String KEY_RELATIVE_PATH = "VideoViewActivity.URI";
    private AssetVideoView videoView;

    public static Intent newIntent(Context context, String relativeVideoPath) {
        Intent intent = new Intent(context, ViewVideoActivity.class);
        intent.putExtra(KEY_RELATIVE_PATH, relativeVideoPath);
        return intent;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        super.setContentView(R.layout.rsb_activity_video_viewer);
        this.videoView = (AssetVideoView)this.findViewById(R.id.videoView);
        MediaController mediaController = new MediaController((Context)this, false);
        mediaController.setAnchorView((View)this.videoView);
        this.videoView.setMediaController(mediaController);
        try {
            String videoPath = this.getIntent().getStringExtra(KEY_RELATIVE_PATH);
            AssetFileDescriptor afd = this.getAssets().openFd(videoPath);
            this.videoView.setVideoDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength());
            this.videoView.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.videoView.isPlaying()) {
            this.videoView.pause();
        }
    }
}

