/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.ui;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import android.view.inputmethod.InputMethodManager;
import android.widget.Toast;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Date;
import org.researchstack.backbone.R;
import org.researchstack.backbone.result.StepResult;
import org.researchstack.backbone.result.TaskResult;
import org.researchstack.backbone.step.Step;
import org.researchstack.backbone.task.Task;
import org.researchstack.backbone.ui.PinCodeActivity;
import org.researchstack.backbone.ui.ViewTaskActivity$$Lambda$1;
import org.researchstack.backbone.ui.callbacks.StepCallbacks;
import org.researchstack.backbone.ui.step.layout.StepLayout;
import org.researchstack.backbone.ui.views.StepSwitcher;

public class ViewTaskActivity
extends PinCodeActivity
implements StepCallbacks {
    public static final String EXTRA_TASK = "ViewTaskActivity.ExtraTask";
    public static final String EXTRA_TASK_RESULT = "ViewTaskActivity.ExtraTaskResult";
    public static final String EXTRA_STEP = "ViewTaskActivity.ExtraStep";
    private StepSwitcher root;
    private Step currentStep;
    private Task task;
    private TaskResult taskResult;

    public static Intent newIntent(Context context, Task task) {
        Intent intent = new Intent(context, ViewTaskActivity.class);
        intent.putExtra(EXTRA_TASK, (Serializable)task);
        return intent;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        super.setResult(0);
        super.setContentView(R.layout.rsb_activity_step_switcher);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(toolbar);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.root = (StepSwitcher)this.findViewById(R.id.container);
        if (savedInstanceState == null) {
            this.task = (Task)this.getIntent().getSerializableExtra(EXTRA_TASK);
            this.taskResult = new TaskResult(this.task.getIdentifier());
            this.taskResult.setStartDate(new Date());
        } else {
            this.task = (Task)savedInstanceState.getSerializable(EXTRA_TASK);
            this.taskResult = (TaskResult)savedInstanceState.getSerializable(EXTRA_TASK_RESULT);
            this.currentStep = (Step)savedInstanceState.getSerializable(EXTRA_STEP);
        }
        this.task.validateParameters();
        this.task.onViewChange(Task.ViewChangeType.ActivityCreate, this, this.currentStep);
    }

    public Step getCurrentStep() {
        return this.currentStep;
    }

    protected void showNextStep() {
        Step nextStep = this.task.getStepAfterStep(this.currentStep, this.taskResult);
        if (nextStep == null) {
            this.saveAndFinish();
        } else {
            this.showStep(nextStep);
        }
    }

    protected void showPreviousStep() {
        Step previousStep = this.task.getStepBeforeStep(this.currentStep, this.taskResult);
        if (previousStep == null) {
            this.finish();
        } else {
            this.showStep(previousStep);
        }
    }

    private void showStep(Step step) {
        int currentStepPosition = this.task.getProgressOfCurrentStep(this.currentStep, this.taskResult).getCurrent();
        int newStepPosition = this.task.getProgressOfCurrentStep(step, this.taskResult).getCurrent();
        StepLayout stepLayout = this.getLayoutForStep(step);
        stepLayout.getLayout().setTag(R.id.rsb_step_layout_id, (Object)step.getIdentifier());
        this.root.show(stepLayout, newStepPosition >= currentStepPosition ? 1 : -1);
        this.currentStep = step;
    }

    protected StepLayout getLayoutForStep(Step step) {
        String title = this.task.getTitleForStep((Context)this, step);
        this.setActionBarTitle(title);
        StepResult result = this.taskResult.getStepResult(step.getIdentifier());
        StepLayout stepLayout = this.createLayoutFromStep(step);
        stepLayout.initialize(step, result);
        stepLayout.setCallbacks(this);
        return stepLayout;
    }

    @NonNull
    private StepLayout createLayoutFromStep(Step step) {
        try {
            Class cls = step.getStepLayoutClass();
            Constructor constructor = cls.getConstructor(Context.class);
            return (StepLayout)constructor.newInstance(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void saveAndFinish() {
        this.taskResult.setEndDate(new Date());
        Intent resultIntent = new Intent();
        resultIntent.putExtra(EXTRA_TASK_RESULT, (Serializable)this.taskResult);
        this.setResult(-1, resultIntent);
        this.finish();
    }

    @Override
    protected void onPause() {
        this.hideKeyboard();
        super.onPause();
        this.task.onViewChange(Task.ViewChangeType.ActivityPause, this, this.currentStep);
    }

    @Override
    protected void onResume() {
        super.onResume();
        this.task.onViewChange(Task.ViewChangeType.ActivityResume, this, this.currentStep);
    }

    protected void onStop() {
        super.onStop();
        this.task.onViewChange(Task.ViewChangeType.ActivityStop, this, this.currentStep);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.notifyStepOfBackPress();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        this.notifyStepOfBackPress();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putSerializable(EXTRA_TASK, (Serializable)this.task);
        outState.putSerializable(EXTRA_TASK_RESULT, (Serializable)this.taskResult);
        outState.putSerializable(EXTRA_STEP, (Serializable)this.currentStep);
    }

    private void notifyStepOfBackPress() {
        StepLayout currentStepLayout = (StepLayout)this.findViewById(R.id.rsb_current_step);
        currentStepLayout.isBackEventConsumed();
    }

    @Override
    public void onDataReady() {
        super.onDataReady();
        if (this.currentStep == null) {
            this.currentStep = this.task.getStepAfterStep(null, this.taskResult);
        }
        this.showStep(this.currentStep);
    }

    @Override
    public void onDataFailed() {
        super.onDataFailed();
        Toast.makeText((Context)this, (int)R.string.rsb_error_data_failed, (int)1).show();
        this.finish();
    }

    @Override
    public void onSaveStep(int action, Step step, StepResult result) {
        this.onSaveStepResult(step.getIdentifier(), result);
        this.onExecuteStepAction(action);
    }

    protected void onSaveStepResult(String id2, StepResult result) {
        this.taskResult.setStepResultForStepIdentifier(id2, result);
    }

    protected void onExecuteStepAction(int action) {
        if (action == 1) {
            this.showNextStep();
        } else if (action == -1) {
            this.showPreviousStep();
        } else if (action == 2) {
            this.showConfirmExitDialog();
        } else if (action != 0) {
            throw new IllegalArgumentException("Action with value " + action + " is invalid. " + "See StepCallbacks for allowable arguments");
        }
    }

    private void hideKeyboard() {
        InputMethodManager imm = (InputMethodManager)this.getSystemService("input_method");
        if (imm.isActive() && imm.isAcceptingText()) {
            imm.toggleSoftInput(1, 0);
        }
    }

    private void showConfirmExitDialog() {
        AlertDialog alertDialog = new AlertDialog.Builder((Context)this).setTitle((CharSequence)"Are you sure you want to exit?").setMessage(R.string.lorem_medium).setPositiveButton((CharSequence)"End Task", ViewTaskActivity$$Lambda$1.lambdaFactory$(this)).setNegativeButton((CharSequence)"Cancel", null).create();
        alertDialog.show();
    }

    @Override
    public void onCancelStep() {
        this.setResult(0);
        this.finish();
    }

    public void setActionBarTitle(String title) {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setTitle((CharSequence)title);
        }
    }

    private /* synthetic */ void lambda$showConfirmExitDialog$0(DialogInterface dialog, int which) {
        this.finish();
    }

    static /* synthetic */ void access$lambda$0(ViewTaskActivity viewTaskActivity, DialogInterface dialogInterface, int n) {
        viewTaskActivity.lambda$showConfirmExitDialog$0(dialogInterface, n);
    }
}

