/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.ui;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.app.AppCompatActivity;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import com.jakewharton.rxbinding.widget.RxTextView;
import java.util.List;
import org.researchstack.backbone.R;
import org.researchstack.backbone.StorageAccess;
import org.researchstack.backbone.storage.file.PinCodeConfig;
import org.researchstack.backbone.storage.file.StorageAccessListener;
import org.researchstack.backbone.ui.PinCodeActivity$$Lambda$1;
import org.researchstack.backbone.ui.PinCodeActivity$$Lambda$10;
import org.researchstack.backbone.ui.PinCodeActivity$$Lambda$11;
import org.researchstack.backbone.ui.PinCodeActivity$$Lambda$4;
import org.researchstack.backbone.ui.PinCodeActivity$$Lambda$5;
import org.researchstack.backbone.ui.PinCodeActivity$$Lambda$6;
import org.researchstack.backbone.ui.PinCodeActivity$$Lambda$7;
import org.researchstack.backbone.ui.PinCodeActivity$$Lambda$8;
import org.researchstack.backbone.ui.PinCodeActivity$$Lambda$9;
import org.researchstack.backbone.ui.views.PinCodeLayout;
import org.researchstack.backbone.utils.LogExt;
import org.researchstack.backbone.utils.ThemeUtils;
import rx.Observable;
import rx.functions.Action1;

public class PinCodeActivity
extends AppCompatActivity
implements StorageAccessListener {
    private PinCodeLayout pinCodeLayout;
    private Action1<Boolean> toggleKeyboardAction;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    protected void onPause() {
        super.onPause();
        LogExt.i(this.getClass(), "logAccessTime()");
        StorageAccess.getInstance().logAccessTime();
    }

    protected void onResume() {
        super.onResume();
        this.requestStorageAccess();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.storageAccessUnregister();
        if (this.pinCodeLayout != null) {
            this.getWindowManager().removeView((View)this.pinCodeLayout);
        }
    }

    protected void requestStorageAccess() {
        LogExt.i(this.getClass(), "requestStorageAccess()");
        StorageAccess storageAccess = StorageAccess.getInstance();
        this.storageAccessRegister();
        storageAccess.requestStorageAccess((Context)this);
    }

    protected void storageAccessRegister() {
        LogExt.i(this.getClass(), "storageAccessRegister()");
        StorageAccess storageAccess = StorageAccess.getInstance();
        storageAccess.register(this);
    }

    protected void storageAccessUnregister() {
        LogExt.i(this.getClass(), "storageAccessUnregister()");
        StorageAccess storageAccess = StorageAccess.getInstance();
        storageAccess.unregister(this);
    }

    @Override
    public void onDataReady() {
        LogExt.i(this.getClass(), "onDataReady()");
        this.storageAccessUnregister();
        new Handler().post(PinCodeActivity$$Lambda$1.lambdaFactory$(this));
    }

    @Override
    public void onDataFailed() {
        LogExt.e(this.getClass(), "onDataFailed()");
        this.storageAccessUnregister();
        List fragments = this.getSupportFragmentManager().getFragments();
        if (fragments != null) {
            LogExt.i(this.getClass(), "Fragments found on stack. Checking for StorageAccessListener.");
            for (Fragment fragment : fragments) {
                if (!(fragment instanceof StorageAccessListener)) continue;
                LogExt.i(this.getClass(), "Notifying " + fragment.getClass().getSimpleName() + " of onDataFailed");
                ((StorageAccessListener)fragment).onDataFailed();
            }
        }
    }

    @Override
    public void onDataAuth() {
        LogExt.e(this.getClass(), "onDataAuth()");
        this.storageAccessUnregister();
        PinCodeConfig config = StorageAccess.getInstance().getPinCodeConfig();
        int theme = ThemeUtils.getPassCodeTheme((Context)this);
        this.pinCodeLayout = new PinCodeLayout((Context)new ContextThemeWrapper((Context)this, theme));
        this.pinCodeLayout.setBackgroundColor(-1);
        int errorColor = this.getResources().getColor(R.color.rsb_error);
        TextView summary = (TextView)this.pinCodeLayout.findViewById(R.id.text);
        EditText pincode = (EditText)this.pinCodeLayout.findViewById(R.id.pincode);
        this.toggleKeyboardAction = PinCodeActivity$$Lambda$4.lambdaFactory$(this, pincode);
        RxTextView.textChanges((TextView)pincode).map(PinCodeActivity$$Lambda$5.lambdaFactory$()).doOnNext(PinCodeActivity$$Lambda$6.lambdaFactory$(this, summary, errorColor)).filter(PinCodeActivity$$Lambda$7.lambdaFactory$(config)).doOnNext(PinCodeActivity$$Lambda$8.lambdaFactory$(this, pincode)).flatMap(PinCodeActivity$$Lambda$9.lambdaFactory$(this, summary, errorColor)).subscribe(PinCodeActivity$$Lambda$10.lambdaFactory$(this));
        WindowManager.LayoutParams params = new WindowManager.LayoutParams();
        this.getWindowManager().addView((View)this.pinCodeLayout, (ViewGroup.LayoutParams)params);
        this.pinCodeLayout.postDelayed(PinCodeActivity$$Lambda$11.lambdaFactory$(this), 300L);
    }

    private /* synthetic */ void lambda$onDataAuth$10() {
        this.toggleKeyboardAction.call((Object)true);
    }

    private /* synthetic */ void lambda$onDataAuth$9(Boolean success) {
        if (!success.booleanValue()) {
            this.toggleKeyboardAction.call((Object)true);
        } else {
            this.getWindowManager().removeView((View)this.pinCodeLayout);
            this.pinCodeLayout = null;
            this.requestStorageAccess();
        }
    }

    /*
     * Exception decompiling
     */
    private /* synthetic */ Observable lambda$onDataAuth$8(TextView summary, int errorColor, String pin) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ Observable lambda$null$7(Throwable throwable1) {
        return Observable.empty();
    }

    private /* synthetic */ void lambda$null$6(TextView summary, int errorColor, Throwable throwable) {
        this.toggleKeyboardAction.call((Object)true);
        throwable.printStackTrace();
        summary.setText(R.string.rsb_pincode_enter_error);
        summary.setTextColor(errorColor);
        this.pinCodeLayout.showProgress(false);
    }

    private /* synthetic */ Boolean lambda$null$5(String pin) throws Exception {
        StorageAccess.getInstance().authenticate((Context)this, pin);
        return true;
    }

    private /* synthetic */ void lambda$onDataAuth$4(EditText pincode, String pin) {
        pincode.setEnabled(false);
        this.pinCodeLayout.showProgress(true);
    }

    private static /* synthetic */ Boolean lambda$onDataAuth$3(PinCodeConfig config, String pin) {
        return pin != null && pin.length() == config.getPinLength();
    }

    private /* synthetic */ void lambda$onDataAuth$2(TextView summary, int errorColor, String pin) {
        if (summary.getCurrentTextColor() == errorColor) {
            summary.setTextColor(ThemeUtils.getTextColorPrimary((Context)this));
            this.pinCodeLayout.resetSummaryText();
        }
    }

    private /* synthetic */ void lambda$onDataAuth$1(EditText pincode, Boolean enable) {
        pincode.setEnabled(enable.booleanValue());
        pincode.setText((CharSequence)"");
        pincode.requestFocus();
        if (enable.booleanValue()) {
            InputMethodManager imm = (InputMethodManager)this.getSystemService("input_method");
            imm.showSoftInput((View)pincode, 2);
        }
    }

    private /* synthetic */ void lambda$onDataReady$0() {
        List fragments = this.getSupportFragmentManager().getFragments();
        if (fragments != null) {
            LogExt.i(this.getClass(), "Fragments found on stack. Checking for StorageAccessListener.");
            for (Fragment fragment : fragments) {
                if (!(fragment instanceof StorageAccessListener)) continue;
                LogExt.i(this.getClass(), "Notifying " + fragment.getClass().getSimpleName() + " of onDataReady");
                ((StorageAccessListener)fragment).onDataReady();
            }
        }
    }

    static /* synthetic */ void access$lambda$0(PinCodeActivity pinCodeActivity) {
        pinCodeActivity.lambda$onDataReady$0();
    }

    static /* synthetic */ void access$lambda$1(PinCodeActivity pinCodeActivity, EditText editText, Boolean bl) {
        pinCodeActivity.lambda$onDataAuth$1(editText, bl);
    }

    static /* synthetic */ void access$lambda$2(PinCodeActivity pinCodeActivity, TextView textView, int n, String string2) {
        pinCodeActivity.lambda$onDataAuth$2(textView, n, string2);
    }

    static /* synthetic */ Boolean access$lambda$3(PinCodeConfig pinCodeConfig, String string2) {
        return PinCodeActivity.lambda$onDataAuth$3(pinCodeConfig, string2);
    }

    static /* synthetic */ void access$lambda$4(PinCodeActivity pinCodeActivity, EditText editText, String string2) {
        pinCodeActivity.lambda$onDataAuth$4(editText, string2);
    }

    static /* synthetic */ Observable access$lambda$5(PinCodeActivity pinCodeActivity, TextView textView, int n, String string2) {
        return pinCodeActivity.lambda$onDataAuth$8(textView, n, string2);
    }

    static /* synthetic */ void access$lambda$6(PinCodeActivity pinCodeActivity, Boolean bl) {
        pinCodeActivity.lambda$onDataAuth$9(bl);
    }

    static /* synthetic */ void access$lambda$7(PinCodeActivity pinCodeActivity) {
        pinCodeActivity.lambda$onDataAuth$10();
    }

    static /* synthetic */ Boolean access$lambda$8(PinCodeActivity pinCodeActivity, String string2) {
        return pinCodeActivity.lambda$null$5(string2);
    }

    static /* synthetic */ void access$lambda$9(PinCodeActivity pinCodeActivity, TextView textView, int n, Throwable throwable) {
        pinCodeActivity.lambda$null$6(textView, n, throwable);
    }

    static /* synthetic */ Observable access$lambda$10(Throwable throwable) {
        return PinCodeActivity.lambda$null$7(throwable);
    }
}

