/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.task;

import android.content.Context;
import java.io.Serializable;
import org.researchstack.backbone.result.TaskResult;
import org.researchstack.backbone.step.Step;
import org.researchstack.backbone.ui.ViewTaskActivity;

public abstract class Task
implements Serializable {
    private String identifier;

    public Task(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getTitleForStep(Context context, Step step) {
        return step.getStepTitle() != 0 ? context.getString(step.getStepTitle()) : "";
    }

    public abstract Step getStepAfterStep(Step var1, TaskResult var2);

    public abstract Step getStepBeforeStep(Step var1, TaskResult var2);

    public abstract Step getStepWithIdentifier(String var1);

    public abstract TaskProgress getProgressOfCurrentStep(Step var1, TaskResult var2);

    public abstract void validateParameters();

    public void onViewChange(ViewChangeType type, ViewTaskActivity activity, Step currentStep) {
    }

    public static enum ViewChangeType {
        ActivityCreate,
        ActivityPause,
        ActivityResume,
        ActivityStop,
        StepChanged;

    }

    public static class InvalidTaskException
    extends RuntimeException {
        public InvalidTaskException() {
        }

        public InvalidTaskException(String detailMessage) {
            super(detailMessage);
        }

        public InvalidTaskException(String detailMessage, Throwable throwable) {
            super(detailMessage, throwable);
        }

        public InvalidTaskException(Throwable throwable) {
            super(throwable);
        }
    }

    public static class TaskProgress {
        private final int current;
        private final int total;

        public TaskProgress(int current, int total) {
            this.current = current;
            this.total = total;
        }

        public int getCurrent() {
            return this.current;
        }

        public int getTotal() {
            return this.total;
        }
    }
}

