/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.task;

import android.content.Context;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.researchstack.backbone.R;
import org.researchstack.backbone.result.TaskResult;
import org.researchstack.backbone.step.Step;
import org.researchstack.backbone.task.Task;
import org.researchstack.backbone.utils.TextUtils;

public class OrderedTask
extends Task
implements Serializable {
    protected List<Step> steps;

    public OrderedTask(String identifier, List<Step> steps) {
        super(identifier);
        this.steps = new ArrayList<Step>(steps);
    }

    public OrderedTask(String identifier, Step ... steps) {
        this(identifier, Arrays.asList(steps));
    }

    @Override
    public Step getStepAfterStep(Step step, TaskResult result) {
        if (step == null) {
            return this.steps.get(0);
        }
        int nextIndex = this.steps.indexOf(step) + 1;
        if (nextIndex < this.steps.size()) {
            return this.steps.get(nextIndex);
        }
        return null;
    }

    @Override
    public Step getStepBeforeStep(Step step, TaskResult result) {
        int nextIndex = this.steps.indexOf(step) - 1;
        if (nextIndex >= 0) {
            return this.steps.get(nextIndex);
        }
        return null;
    }

    @Override
    public Step getStepWithIdentifier(String identifier) {
        for (Step step : this.steps) {
            if (!identifier.equals(step.getIdentifier())) continue;
            return step;
        }
        return null;
    }

    @Override
    public Task.TaskProgress getProgressOfCurrentStep(Step step, TaskResult result) {
        int current = step == null ? -1 : this.steps.indexOf(step);
        return new Task.TaskProgress(current, this.steps.size());
    }

    @Override
    public String getTitleForStep(Context context, Step step) {
        String title = super.getTitleForStep(context, step);
        if (TextUtils.isEmpty(title)) {
            int currentIndex = this.steps.indexOf(step);
            title = context.getString(R.string.rsb_format_step_title, new Object[]{currentIndex + 1, this.steps.size()});
        }
        return title;
    }

    @Override
    public void validateParameters() {
        HashSet<String> uniqueIds = new HashSet<String>();
        for (Step step : this.steps) {
            uniqueIds.add(step.getIdentifier());
        }
        if (uniqueIds.size() != this.steps.size()) {
            throw new Task.InvalidTaskException("OrderedTask has steps with duplicate ids");
        }
    }

    public List<Step> getSteps() {
        return new ArrayList<Step>(this.steps);
    }
}

