/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.storage.file.aes;

import android.content.Context;
import android.support.annotation.NonNull;
import com.tozny.crypto.android.AesCbcWithIntegrity;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import org.researchstack.backbone.storage.file.EncryptionProvider;
import org.researchstack.backbone.storage.file.PinCodeConfig;
import org.researchstack.backbone.storage.file.StorageAccessException;
import org.researchstack.backbone.storage.file.aes.Encrypter;
import org.researchstack.backbone.utils.FileUtils;

public abstract class PinProtectedProvider
implements EncryptionProvider {
    private Encrypter encrypter;
    private long lastAuthTime;

    @Override
    public Encrypter getEncrypter() {
        return this.encrypter;
    }

    private void validateKeyForTimeOut(long autoLockTime) {
        boolean isPastMinIgnoreTime;
        long now = System.currentTimeMillis();
        boolean bl = isPastMinIgnoreTime = now - this.lastAuthTime > autoLockTime;
        if (isPastMinIgnoreTime) {
            this.encrypter = null;
        }
    }

    @Override
    public void logAccessTime() {
        this.lastAuthTime = System.currentTimeMillis();
    }

    @Override
    public boolean hasPinCode(Context context) {
        return this.passphraseExists(context);
    }

    @Override
    public void createPinCode(Context context, String pin) {
        try {
            File masterKeyFile = this.createMasterKeyFile(context);
            AesCbcWithIntegrity.SecretKeys masterKey = AesCbcWithIntegrity.generateKey();
            this.writeMasterKey(context, masterKeyFile, masterKey, pin);
            this.initWithMasterKey(masterKey);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new StorageAccessException(e);
        }
    }

    @Override
    public void changePinCode(Context context, String oldPin, String newPin) {
        try {
            File masterKeyFile = this.createMasterKeyFile(context);
            String masterKeyString = this.readMasterKey(context, masterKeyFile, oldPin);
            AesCbcWithIntegrity.SecretKeys masterKey = AesCbcWithIntegrity.keys((String)masterKeyString);
            this.writeMasterKey(context, masterKeyFile, masterKey, newPin);
            this.initWithMasterKey(masterKey);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new StorageAccessException(e);
        }
    }

    private void initWithMasterKey(AesCbcWithIntegrity.SecretKeys masterKey) {
        this.encrypter = this.createEncrypter(masterKey);
        this.logAccessTime();
    }

    protected abstract Encrypter createEncrypter(AesCbcWithIntegrity.SecretKeys var1);

    @Override
    public void startWithPassphrase(Context context, String passphrase) {
        try {
            File masterKeyFile = this.createMasterKeyFile(context);
            if (!masterKeyFile.exists()) {
                throw new IllegalAccessException("Master-key file does not exist. You should callcreatePinCode(String pin) to create a Master-key file and encrypt w/ pin-code");
            }
            String masterKeyString = this.readMasterKey(context, masterKeyFile, passphrase);
            AesCbcWithIntegrity.SecretKeys masterKey = AesCbcWithIntegrity.keys((String)masterKeyString);
            this.initWithMasterKey(masterKey);
        }
        catch (IOException | IllegalAccessException | GeneralSecurityException e) {
            throw new StorageAccessException(e);
        }
    }

    public boolean passphraseExists(Context context) {
        File masterKeyFile = this.createMasterKeyFile(context);
        return masterKeyFile.exists();
    }

    @NonNull
    private File createMasterKeyFile(Context context) {
        File secure = this.createSecureDirectory(context);
        return new File(secure, "__encrypted");
    }

    @NonNull
    private File createSaltFile(Context context) {
        File secure = this.createSecureDirectory(context);
        return new File(secure, "__sodium");
    }

    @NonNull
    private File createSecureDirectory(Context context) {
        File file = new File(context.getFilesDir(), "secure");
        file.mkdirs();
        return file;
    }

    @NonNull
    private String readMasterKey(Context context, File file, String passphrase) throws IOException, GeneralSecurityException {
        byte[] decrypted = this.decryptFile(file, this.generatePassphraseKey(context, passphrase));
        return new String(decrypted);
    }

    private void writeMasterKey(Context context, File file, AesCbcWithIntegrity.SecretKeys masterKey, String passphrase) throws GeneralSecurityException, IOException {
        byte[] encrypted = this.encrypt(masterKey.toString().getBytes(), this.generatePassphraseKey(context, passphrase));
        FileUtils.writeSafe(file, encrypted);
    }

    @NonNull
    private byte[] decryptFile(File file, AesCbcWithIntegrity.SecretKeys secretKeys) throws IOException, GeneralSecurityException {
        String encrypted = new String(FileUtils.readAll(file));
        AesCbcWithIntegrity.CipherTextIvMac cipherText = new AesCbcWithIntegrity.CipherTextIvMac(encrypted);
        return AesCbcWithIntegrity.decrypt((AesCbcWithIntegrity.CipherTextIvMac)cipherText, (AesCbcWithIntegrity.SecretKeys)secretKeys);
    }

    private byte[] encrypt(byte[] data, AesCbcWithIntegrity.SecretKeys secretKeys) throws UnsupportedEncodingException, GeneralSecurityException {
        return AesCbcWithIntegrity.encrypt((byte[])data, (AesCbcWithIntegrity.SecretKeys)secretKeys).toString().getBytes();
    }

    @NonNull
    private AesCbcWithIntegrity.SecretKeys generatePassphraseKey(Context context, String passphrase) throws GeneralSecurityException, IOException {
        return AesCbcWithIntegrity.generateKeyFromPassword((String)passphrase, (byte[])this.getSalt(context));
    }

    private byte[] getSalt(Context context) throws GeneralSecurityException, IOException {
        File salt = this.createSaltFile(context);
        if (!salt.exists()) {
            byte[] saltBytes = AesCbcWithIntegrity.generateSalt();
            FileUtils.writeSafe(salt, saltBytes);
        }
        return FileUtils.readAll(salt);
    }

    @Override
    public boolean needsAuth(Context context, PinCodeConfig codeConfig) {
        this.validateKeyForTimeOut(codeConfig.getPinAutoLockTime());
        return this.encrypter == null;
    }
}

