/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.storage.file;

import android.text.InputFilter;
import org.researchstack.backbone.R;
import org.researchstack.backbone.utils.TextUtils;

public class PinCodeConfig {
    private static final String DIGITS_NUMERIC = "1234567890";
    private static final String DIGITS_ALPHABETIC = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String DIGITS_ALPHANUMERIC = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
    private Type type;
    private long autoLockTime;
    private int length;

    public PinCodeConfig() {
        this(300000L);
    }

    public PinCodeConfig(long autoLockTime) {
        this(PinCodeType.Numeric, 4, autoLockTime);
    }

    public PinCodeConfig(Type type, int length, long autoLockTime) {
        this.type = type;
        this.length = length;
        this.autoLockTime = autoLockTime;
    }

    public Type getPinType() {
        return this.type;
    }

    public int getPinLength() {
        return this.length;
    }

    public long getPinAutoLockTime() {
        return this.autoLockTime;
    }

    public void setPinAutoLockTime(long pinAutoLockTime) {
        this.autoLockTime = pinAutoLockTime;
    }

    public static enum PinCodeType implements Type
    {
        Alphabetic(524288, 0, 128, new TextUtils.AlphabeticFilter()),
        Numeric(2, 0, 16, new TextUtils.NumericFilter()),
        AlphaNumeric(524288, 0, 128, new TextUtils.AlphanumericFilter());

        private int inputType;
        private int inputTypeVisible;
        private int inputTypeHidden;
        private InputFilter filter;

        private PinCodeType(int inputType, int inputTypeVisible, int inputTypeHidden, InputFilter filter) {
            this.inputType = inputType;
            this.inputTypeVisible = inputTypeVisible;
            this.inputTypeHidden = inputTypeHidden;
            this.filter = filter;
        }

        @Override
        public int getInputType() {
            return this.inputType;
        }

        @Override
        public int getInputTypeStringId() {
            if (this == Numeric) {
                return R.string.rsb_pincode_enter_digit;
            }
            if (this == Alphabetic) {
                return R.string.rsb_pincode_enter_letter;
            }
            return R.string.rsb_pincode_enter_character;
        }

        @Override
        public InputFilter getInputFilter() {
            return this.filter;
        }

        @Override
        public int getVisibleVariationType(boolean visible) {
            return visible ? this.inputTypeVisible : this.inputTypeHidden;
        }
    }

    public static interface Type {
        public int getInputType();

        public int getInputTypeStringId();

        public InputFilter getInputFilter();

        public int getVisibleVariationType(boolean var1);
    }
}

