/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.storage.database.sqlite;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import co.touchlab.squeaky.dao.Dao;
import co.touchlab.squeaky.db.SQLiteDatabase;
import co.touchlab.squeaky.db.sqlite.SQLiteDatabaseImpl;
import co.touchlab.squeaky.db.sqlite.SqueakyOpenHelper;
import co.touchlab.squeaky.table.TableUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.researchstack.backbone.result.StepResult;
import org.researchstack.backbone.result.TaskResult;
import org.researchstack.backbone.storage.database.AppDatabase;
import org.researchstack.backbone.storage.database.StepRecord;
import org.researchstack.backbone.storage.database.TaskRecord;
import org.researchstack.backbone.utils.LogExt;

public class DatabaseHelper
extends SqueakyOpenHelper
implements AppDatabase {
    public static final String DEFAULT_NAME = "appdb";
    public static final int DEFAULT_VERSION = 1;

    public DatabaseHelper(Context context, String name, SQLiteDatabase.CursorFactory factory, int version) {
        super(context, name, factory, version);
    }

    public void onCreate(android.database.sqlite.SQLiteDatabase sqLiteDatabase) {
        try {
            TableUtils.createTables((SQLiteDatabase)new SQLiteDatabaseImpl(sqLiteDatabase), (Class[])new Class[]{TaskRecord.class, StepRecord.class});
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void onUpgrade(android.database.sqlite.SQLiteDatabase sqLiteDatabase, int i, int i1) {
    }

    @Override
    public void saveTaskResult(TaskResult taskResult) {
        LogExt.d(this.getClass(), "saveTaskResult() id: " + taskResult.getIdentifier());
        try {
            TaskRecord taskRecord = new TaskRecord();
            taskRecord.taskId = taskResult.getIdentifier();
            taskRecord.started = taskResult.getStartDate();
            taskRecord.completed = taskResult.getEndDate();
            this.getDao(TaskRecord.class).create((Object)taskRecord);
            Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create();
            Dao stepResultDao = this.getDao(StepRecord.class);
            for (StepResult stepResult : taskResult.getResults().values()) {
                if (stepResult == null) continue;
                StepRecord stepRecord = new StepRecord();
                stepRecord.taskRecordId = taskRecord.id;
                stepRecord.taskId = taskResult.getIdentifier();
                stepRecord.stepId = stepResult.getIdentifier();
                stepRecord.completed = stepResult.getEndDate();
                if (!stepResult.getResults().isEmpty()) {
                    stepRecord.result = gson.toJson(stepResult.getResults());
                }
                stepResultDao.createOrUpdate((Object)stepRecord);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TaskResult loadLatestTaskResult(String taskIdentifier) {
        LogExt.d(this.getClass(), "loadTaskResults() id: " + taskIdentifier);
        try {
            List taskRecords = this.getDao(TaskRecord.class).queryForEq("taskId", (Object)taskIdentifier).orderBy("completed DESC").limit(Integer.valueOf(1)).list();
            if (taskRecords.isEmpty()) {
                return null;
            }
            TaskRecord record = (TaskRecord)taskRecords.get(0);
            List stepRecords = this.getDao(StepRecord.class).queryForEq("taskRecordId", (Object)record.id).list();
            return TaskRecord.toTaskResult(record, stepRecords);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<TaskResult> loadTaskResults(String taskIdentifier) {
        LogExt.d(this.getClass(), "loadTaskResults() id: " + taskIdentifier);
        try {
            ArrayList<TaskResult> results = new ArrayList<TaskResult>();
            List taskRecords = this.getDao(TaskRecord.class).queryForEq("taskId", (Object)taskIdentifier).list();
            for (TaskRecord record : taskRecords) {
                List stepRecords = this.getDao(StepRecord.class).queryForEq("taskRecordId", (Object)record.id).list();
                TaskResult result = TaskRecord.toTaskResult(record, stepRecords);
                results.add(result);
            }
            return results;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<StepResult> loadStepResults(String stepIdentifier) {
        LogExt.d(this.getClass(), "loadStepResults() id: " + stepIdentifier);
        try {
            ArrayList<StepResult> results = new ArrayList<StepResult>();
            List stepRecords = this.getDao(StepRecord.class).queryForEq("stepId", (Object)stepIdentifier).list();
            for (StepRecord stepRecord : stepRecords) {
                StepResult result = StepRecord.toStepResult(stepRecord);
                results.add(result);
            }
            return results;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setEncryptionKey(String key) {
        LogExt.w(this.getClass(), "No-op, this db implementation is not encrypted");
    }
}

