/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.storage.database;

import co.touchlab.squeaky.field.DatabaseField;
import co.touchlab.squeaky.table.DatabaseTable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Date;
import java.util.Map;
import org.researchstack.backbone.result.StepResult;
import org.researchstack.backbone.step.Step;
import org.researchstack.backbone.utils.TextUtils;

@DatabaseTable
public class StepRecord {
    private static final Gson GSON = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").create();
    public static final String TASK_RECORD_ID = "taskRecordId";
    public static final String STEP_ID = "stepId";
    @DatabaseField(generatedId=true)
    public int id;
    @DatabaseField(canBeNull=false, columnName="taskRecordId")
    public int taskRecordId;
    @DatabaseField(canBeNull=false, columnName="taskId")
    public String taskId;
    @DatabaseField(canBeNull=false, columnName="stepId")
    public String stepId;
    @DatabaseField
    public Date started;
    @DatabaseField
    public Date completed;
    @DatabaseField
    public String result;

    public static StepResult toStepResult(StepRecord record) {
        StepResult result = new StepResult(new Step(record.stepId));
        result.setStartDate(record.started);
        result.setEndDate(record.completed);
        if (!TextUtils.isEmpty(record.result)) {
            result.setResults((Map)GSON.fromJson(record.result, Map.class));
        }
        return result;
    }
}

