/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.storage;

import android.content.Context;
import co.touchlab.squeaky.db.SQLiteDatabase;
import co.touchlab.squeaky.db.sqlite.SQLiteDatabaseImpl;
import co.touchlab.squeaky.db.sqlite.SqueakyOpenHelper;
import co.touchlab.squeaky.table.TableUtils;
import java.sql.SQLException;
import java.util.List;
import org.researchstack.backbone.storage.database.TaskNotification;
import org.researchstack.backbone.utils.LogExt;

public class NotificationHelper
extends SqueakyOpenHelper {
    public static final String DB_NAME = "db_notification";
    private static int DB_VERSION = 1;
    private static NotificationHelper sInstance;

    private NotificationHelper(Context context) {
        super(context, DB_NAME, null, DB_VERSION);
    }

    public static NotificationHelper getInstance(Context context) {
        if (sInstance == null) {
            sInstance = new NotificationHelper(context);
        }
        return sInstance;
    }

    public void onCreate(android.database.sqlite.SQLiteDatabase sqLiteDatabase) {
        try {
            TableUtils.createTables((SQLiteDatabase)new SQLiteDatabaseImpl(sqLiteDatabase), (Class[])new Class[]{TaskNotification.class});
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void onUpgrade(android.database.sqlite.SQLiteDatabase sqLiteDatabase, int i, int i1) {
        try {
            TableUtils.dropTables((SQLiteDatabase)new SQLiteDatabaseImpl(sqLiteDatabase), (boolean)true, (Class[])new Class[]{TaskNotification.class});
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public List<TaskNotification> loadTaskNotifications() {
        LogExt.d(((Object)((Object)this)).getClass(), "loadTaskNotifications()");
        try {
            return this.getDao(TaskNotification.class).queryForAll().list();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void saveTaskNotification(TaskNotification notification) {
        LogExt.d(((Object)((Object)this)).getClass(), "saveTaskNotification() : " + notification.id);
        try {
            this.getDao(TaskNotification.class).createOrUpdate((Object)notification);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteTaskNotification(int taskNotificationId) {
        LogExt.d(((Object)((Object)this)).getClass(), "deleteTaskNotification() : " + taskNotificationId);
        try {
            this.getDao(TaskNotification.class).deleteById((Object)taskNotificationId);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

