/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.result;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.researchstack.backbone.answerformat.AnswerFormat;
import org.researchstack.backbone.result.Result;
import org.researchstack.backbone.step.QuestionStep;
import org.researchstack.backbone.step.Step;

public class StepResult<T>
extends Result {
    public static final String DEFAULT_KEY = "answer";
    private Map<String, T> results = new HashMap<String, T>();
    private AnswerFormat answerFormat;

    public StepResult(Step step) {
        super(step.getIdentifier());
        if (step instanceof QuestionStep) {
            this.answerFormat = ((QuestionStep)step).getAnswerFormat();
        }
        this.setStartDate(new Date());
        this.setEndDate(new Date());
    }

    public Map<String, T> getResults() {
        return this.results;
    }

    public void setResults(Map<String, T> results) {
        this.results = results;
    }

    public T getResult() {
        return this.getResultForIdentifier(DEFAULT_KEY);
    }

    public void setResult(T result) {
        this.setResultForIdentifier(DEFAULT_KEY, result);
        this.setEndDate(new Date());
    }

    public T getResultForIdentifier(String identifier) {
        return this.results.get(identifier);
    }

    public void setResultForIdentifier(String identifier, T result) {
        this.results.put(identifier, result);
    }

    public AnswerFormat getAnswerFormat() {
        return this.answerFormat;
    }
}

