/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.model;

import com.google.gson.annotations.SerializedName;
import java.io.Serializable;
import org.researchstack.backbone.R;
import org.researchstack.backbone.utils.TextUtils;

public class ConsentSection
implements Serializable {
    @SerializedName(value="sectionType")
    private Type type;
    @SerializedName(value="sectionTitle")
    private String title;
    @SerializedName(value="sectionFormalTitle")
    private String formalTitle;
    @SerializedName(value="sectionSummary")
    private String summary;
    @SerializedName(value="sectionContent")
    private String content;
    private String escapedContent;
    @SerializedName(value="sectionHtmlContent")
    private String htmlContent;
    @SerializedName(value="sectionImage")
    private String customImageName;
    @SerializedName(value="sectionMoreTitle")
    private String customLearnMoreButtonTitle;
    @SerializedName(value="sectionAnimationUrl")
    private String customAnimationURL;

    public ConsentSection(Type type) {
        this.type = type;
        this.summary = null;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getFormalTitle() {
        return this.formalTitle;
    }

    public Type getType() {
        return this.type;
    }

    public String getHtmlContent() {
        return this.htmlContent;
    }

    public void setHtmlContent(String htmlContent) {
        this.htmlContent = htmlContent;
    }

    public String getCustomImageName() {
        return this.customImageName;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
        this.escapedContent = null;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getEscapedContent() {
        if (TextUtils.isEmpty(this.content)) {
            return this.content;
        }
        return this.escapedContent;
    }

    public String getCustomLearnMoreButtonTitle() {
        return this.customLearnMoreButtonTitle;
    }

    public static enum Type implements Serializable
    {
        Overview,
        DataGathering,
        Privacy,
        DataUse,
        TimeCommitment,
        StudyTasks,
        StudySurvey,
        Withdrawing,
        Custom,
        OnlyInDocument;


        public int getTitleResId() {
            switch (this) {
                case Overview: {
                    return R.string.rsb_consent_section_welcome;
                }
                case DataGathering: {
                    return R.string.rsb_consent_section_data_gathering;
                }
                case Privacy: {
                    return R.string.rsb_consent_section_privacy;
                }
                case DataUse: {
                    return R.string.rsb_consent_section_data_use;
                }
                case TimeCommitment: {
                    return R.string.rsb_consent_section_time_commitment;
                }
                case StudySurvey: {
                    return R.string.rsb_consent_section_study_survey;
                }
                case StudyTasks: {
                    return R.string.rsb_consent_section_study_tasks;
                }
                case Withdrawing: {
                    return R.string.rsb_consent_section_withdrawing;
                }
            }
            return -1;
        }

        public String getImageName() {
            switch (this) {
                case DataGathering: {
                    return "rsb_consent_section_data_gathering";
                }
                case Privacy: {
                    return "rsb_consent_section_privacy";
                }
                case DataUse: {
                    return "rsb_consent_section_data_use";
                }
                case TimeCommitment: {
                    return "rsb_consent_section_time_commitment";
                }
                case StudySurvey: {
                    return "rsb_consent_section_study_survey";
                }
                case StudyTasks: {
                    return "rsb_consent_section_study_tasks";
                }
                case Withdrawing: {
                    return "rsb_consent_section_withdrawing";
                }
            }
            return null;
        }

        public int getMoreInfoResId() {
            switch (this) {
                case Overview: {
                    return R.string.rsb_consent_section_more_info_welcome;
                }
                case DataGathering: {
                    return R.string.rsb_consent_section_more_info_data_gathering;
                }
                case Privacy: {
                    return R.string.rsb_consent_section_more_info_privacy;
                }
                case DataUse: {
                    return R.string.rsb_consent_section_more_info_data_use;
                }
                case TimeCommitment: {
                    return R.string.rsb_consent_section_more_info_time_commitment;
                }
                case StudySurvey: {
                    return R.string.rsb_consent_section_more_info_study_survey;
                }
                case StudyTasks: {
                    return R.string.rsb_consent_section_more_info_study_tasks;
                }
                case Withdrawing: {
                    return R.string.rsb_consent_section_more_info_withdrawing;
                }
            }
            return R.string.rsb_consent_section_more_info;
        }
    }
}

