/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.answerformat;

import org.researchstack.backbone.R;
import org.researchstack.backbone.answerformat.AnswerFormat;
import org.researchstack.backbone.ui.step.body.BodyAnswer;
import org.researchstack.backbone.utils.TextUtils;

public class IntegerAnswerFormat
extends AnswerFormat {
    private int maxValue;
    private int minValue;

    public IntegerAnswerFormat(int minValue, int maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public AnswerFormat.QuestionType getQuestionType() {
        return AnswerFormat.Type.Integer;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public BodyAnswer validateAnswer(String inputString) {
        if (TextUtils.isEmpty(inputString)) {
            return BodyAnswer.INVALID;
        }
        Integer intAnswer = Integer.valueOf(inputString);
        if (intAnswer < this.getMinValue()) {
            return new BodyAnswer(false, R.string.rsb_invalid_answer_integer_under, String.valueOf(this.getMinValue()));
        }
        if (intAnswer > this.getMaxValue()) {
            return new BodyAnswer(false, R.string.rsb_invalid_answer_integer_over, String.valueOf(this.getMaxValue()));
        }
        return BodyAnswer.VALID;
    }
}

