/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.answerformat;

import org.researchstack.backbone.R;
import org.researchstack.backbone.answerformat.AnswerFormat;
import org.researchstack.backbone.ui.step.body.BodyAnswer;
import org.researchstack.backbone.utils.TextUtils;

public class DecimalAnswerFormat
extends AnswerFormat {
    private float minValue;
    private float maxValue;

    public DecimalAnswerFormat(float minValue, float maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public AnswerFormat.QuestionType getQuestionType() {
        return AnswerFormat.Type.Decimal;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public BodyAnswer validateAnswer(String inputString) {
        if (inputString == null || TextUtils.isEmpty(inputString)) {
            return BodyAnswer.INVALID;
        }
        Float floatAnswer = Float.valueOf(inputString);
        if (floatAnswer.floatValue() < this.minValue) {
            return new BodyAnswer(false, R.string.rsb_invalid_answer_integer_under, String.valueOf(this.getMinValue()));
        }
        if (floatAnswer.floatValue() > this.maxValue) {
            return new BodyAnswer(false, R.string.rsb_invalid_answer_integer_over, String.valueOf(this.getMaxValue()));
        }
        return BodyAnswer.VALID;
    }
}

