/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.answerformat;

import java.util.Date;
import org.researchstack.backbone.R;
import org.researchstack.backbone.answerformat.AnswerFormat;
import org.researchstack.backbone.ui.step.body.BodyAnswer;
import org.researchstack.backbone.utils.FormatHelper;

public class DateAnswerFormat
extends AnswerFormat {
    private AnswerFormat.DateAnswerStyle style;
    private Date defaultDate;
    private Date minimumDate;
    private Date maximumDate;

    public DateAnswerFormat(AnswerFormat.DateAnswerStyle style) {
        this.style = style;
    }

    public DateAnswerFormat(AnswerFormat.DateAnswerStyle style, Date defaultDate, Date minimumDate, Date maximumDate) {
        this.style = style;
        this.defaultDate = defaultDate;
        this.minimumDate = minimumDate;
        this.maximumDate = maximumDate;
    }

    public AnswerFormat.DateAnswerStyle getStyle() {
        return this.style;
    }

    public Date getDefaultDate() {
        return this.defaultDate;
    }

    public Date getMinimumDate() {
        return this.minimumDate;
    }

    public Date getMaximumDate() {
        return this.maximumDate;
    }

    @Override
    public AnswerFormat.QuestionType getQuestionType() {
        if (this.style == AnswerFormat.DateAnswerStyle.Date) {
            return AnswerFormat.Type.Date;
        }
        if (this.style == AnswerFormat.DateAnswerStyle.DateAndTime) {
            return AnswerFormat.Type.DateAndTime;
        }
        if (this.style == AnswerFormat.DateAnswerStyle.TimeOfDay) {
            return AnswerFormat.Type.TimeOfDay;
        }
        return AnswerFormat.Type.None;
    }

    public BodyAnswer validateAnswer(Date resultDate) {
        if (this.minimumDate != null && resultDate.getTime() < this.minimumDate.getTime()) {
            return new BodyAnswer(false, R.string.rsb_invalid_answer_date_under, FormatHelper.SIMPLE_FORMAT_DATE.format(this.minimumDate));
        }
        if (this.maximumDate != null && resultDate.getTime() > this.maximumDate.getTime()) {
            return new BodyAnswer(false, R.string.rsb_invalid_answer_date_over, FormatHelper.SIMPLE_FORMAT_DATE.format(this.maximumDate));
        }
        return BodyAnswer.VALID;
    }
}

