/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone.answerformat;

import java.util.Calendar;
import java.util.Date;
import org.researchstack.backbone.R;
import org.researchstack.backbone.answerformat.AnswerFormat;
import org.researchstack.backbone.answerformat.DateAnswerFormat;
import org.researchstack.backbone.ui.step.body.BodyAnswer;

public class BirthDateAnswerFormat
extends DateAnswerFormat {
    private final int minAge;
    private final int maxAge;

    private static Date dateFromAge(int age) {
        Calendar calendar = Calendar.getInstance();
        if (age != 0) {
            calendar.add(1, -age);
            return calendar.getTime();
        }
        return null;
    }

    public BirthDateAnswerFormat(Date defaultDate, int minAge, int maxAge) {
        super(AnswerFormat.DateAnswerStyle.Date, defaultDate, BirthDateAnswerFormat.dateFromAge(maxAge), BirthDateAnswerFormat.dateFromAge(minAge));
        this.minAge = minAge;
        this.maxAge = maxAge;
    }

    @Override
    public BodyAnswer validateAnswer(Date resultDate) {
        Date minDate = this.getMinimumDate();
        Date maxDate = this.getMaximumDate();
        if (minDate != null && this.isOnOrBefore(resultDate, minDate)) {
            return new BodyAnswer(false, R.string.rsb_birth_date_too_old, String.valueOf(this.maxAge));
        }
        if (maxDate != null && !this.isOnOrBefore(resultDate, maxDate)) {
            return new BodyAnswer(false, R.string.rsb_birth_date_too_young, String.valueOf(this.minAge));
        }
        return BodyAnswer.VALID;
    }

    private boolean isOnOrBefore(Date inputDate, Date cutoffDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(inputDate);
        int year = calendar.get(1);
        int dayOfYear = calendar.get(6);
        calendar.setTime(cutoffDate);
        int cutoffYear = calendar.get(1);
        int cutoffDayOfYear = calendar.get(6);
        return year < cutoffYear || year == cutoffYear && dayOfYear <= cutoffDayOfYear;
    }
}

