/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.MainThread;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.researchstack.backbone.StorageAccess$$Lambda$1;
import org.researchstack.backbone.StorageAccess$$Lambda$2;
import org.researchstack.backbone.StorageAccess$$Lambda$3;
import org.researchstack.backbone.storage.database.AppDatabase;
import org.researchstack.backbone.storage.file.EncryptionProvider;
import org.researchstack.backbone.storage.file.FileAccess;
import org.researchstack.backbone.storage.file.PinCodeConfig;
import org.researchstack.backbone.storage.file.StorageAccessException;
import org.researchstack.backbone.storage.file.StorageAccessListener;
import org.researchstack.backbone.utils.UiThreadContext;

public class StorageAccess {
    private static final boolean CHECK_THREADS = false;
    private static StorageAccess instance = new StorageAccess();
    private FileAccess fileAccess;
    private PinCodeConfig pinCodeConfig;
    private AppDatabase appDatabase;
    private EncryptionProvider encryptionProvider;
    private Handler handler = new Handler(Looper.getMainLooper());
    private List<StorageAccessListener> listeners = Collections.synchronizedList(new ArrayList());

    private StorageAccess() {
    }

    public void init(PinCodeConfig pinCodeConfig, EncryptionProvider encryptionProvider, FileAccess fileAccess, AppDatabase appDatabase) {
        this.pinCodeConfig = pinCodeConfig;
        this.appDatabase = appDatabase;
        this.fileAccess = fileAccess;
        this.encryptionProvider = encryptionProvider;
    }

    public static StorageAccess getInstance() {
        return instance;
    }

    public FileAccess getFileAccess() {
        return this.fileAccess;
    }

    public AppDatabase getAppDatabase() {
        return this.appDatabase;
    }

    public PinCodeConfig getPinCodeConfig() {
        return this.pinCodeConfig;
    }

    public boolean hasPinCode(Context context) {
        return this.encryptionProvider.hasPinCode(context);
    }

    @MainThread
    public void requestStorageAccess(Context context) {
        UiThreadContext.assertUiThread();
        if (this.encryptionProvider.needsAuth(context, this.pinCodeConfig)) {
            this.notifySoftFail();
        } else {
            this.notifyReady();
        }
    }

    @MainThread
    public final void register(StorageAccessListener storageAccessListener) {
        if (this.listeners.contains(storageAccessListener)) {
            throw new StorageAccessException("Listener already registered");
        }
        this.listeners.add(storageAccessListener);
    }

    @MainThread
    public final void unregister(StorageAccessListener storageAccessListener) {
        this.listeners.remove(storageAccessListener);
    }

    private void notifyReady() {
        this.handler.post(StorageAccess$$Lambda$1.lambdaFactory$(this));
    }

    @MainThread
    private void notifyListenersReady() {
        for (StorageAccessListener listener : this.listeners) {
            listener.onDataReady();
        }
    }

    private void notifyHardFail() {
        this.handler.post(StorageAccess$$Lambda$2.lambdaFactory$(this));
    }

    @MainThread
    private void notifyListenersHardFail() {
        for (StorageAccessListener listener : this.listeners) {
            listener.onDataFailed();
        }
    }

    private void notifySoftFail() {
        this.handler.post(StorageAccess$$Lambda$3.lambdaFactory$(this));
    }

    @MainThread
    private void notifyListenersSoftFail() {
        for (StorageAccessListener listener : this.listeners) {
            listener.onDataAuth();
        }
    }

    public void logAccessTime() {
        this.encryptionProvider.logAccessTime();
    }

    public void authenticate(Context context, String pin) {
        this.encryptionProvider.startWithPassphrase(context, pin);
        this.injectEncrypter();
    }

    public void createPinCode(Context context, String pin) {
        if (this.hasPinCode(context)) {
            throw new StorageAccessException("Attempted to create a pin when one already exists");
        }
        this.encryptionProvider.createPinCode(context, pin);
        this.injectEncrypter();
    }

    public void changePinCode(Context context, String oldPin, String newPin) {
        this.encryptionProvider.changePinCode(context, oldPin, newPin);
        this.injectEncrypter();
    }

    private void injectEncrypter() {
        this.fileAccess.setEncrypter(this.encryptionProvider.getEncrypter());
        this.appDatabase.setEncryptionKey(this.encryptionProvider.getEncrypter().getDbKey());
    }

    static /* synthetic */ void access$lambda$0(StorageAccess storageAccess) {
        storageAccess.notifyListenersReady();
    }

    static /* synthetic */ void access$lambda$1(StorageAccess storageAccess) {
        storageAccess.notifyListenersHardFail();
    }

    static /* synthetic */ void access$lambda$2(StorageAccess storageAccess) {
        storageAccess.notifyListenersSoftFail();
    }
}

