/*
 * Decompiled with CFR 0.152.
 */
package org.researchstack.backbone;

import android.content.Context;
import android.content.res.AssetManager;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.researchstack.backbone.utils.LogExt;

public abstract class ResourcePathManager {
    private static Gson gson = new GsonBuilder().setDateFormat("MMM yyyy").create();
    private static ResourcePathManager instance;

    public static void init(ResourcePathManager manager) {
        instance = manager;
    }

    public static ResourcePathManager getInstance() {
        if (instance == null) {
            throw new RuntimeException("ResourceManager instance is null. Make sure to init a concrete implementation of ResearchStack in Application.onCreate()");
        }
        return instance;
    }

    public abstract String generatePath(int var1, String var2);

    public String generateAbsolutePath(int type, String name) {
        return "file:///android_asset/" + this.generatePath(type, name);
    }

    public String getFileExtension(int type) {
        switch (type) {
            case 0: {
                return "html";
            }
            case 1: {
                return "json";
            }
            case 2: {
                return "pdf";
            }
            case 3: {
                return "mp4";
            }
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    public static String getResourceAsString(Context context, String filePath) {
        return new String(ResourcePathManager.getResourceAsBytes(context, filePath), Charset.forName("UTF-8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getResourceAsBytes(Context context, String filePath) {
        InputStream is = ResourcePathManager.getResouceAsInputStream(context, filePath);
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        byte[] readBuffer = new byte[4096];
        try {
            int read;
            while ((read = is.read(readBuffer, 0, readBuffer.length)) != -1) {
                byteOutput.write(readBuffer, 0, read);
            }
            byte[] byArray = byteOutput.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            LogExt.e(ResourcePathManager.class, e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                LogExt.e(ResourcePathManager.class, e);
            }
        }
        return null;
    }

    public static InputStream getResouceAsInputStream(Context context, String filePath) {
        AssetManager assetManager = context.getAssets();
        Object inputStream = null;
        try {
            return assetManager.open(filePath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T getResourceAsClass(Context context, Class<T> clazz, String filePath) {
        InputStream stream = ResourcePathManager.getResouceAsInputStream(context, filePath);
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(stream, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return (T)gson.fromJson((Reader)reader, clazz);
    }

    public static class Resource {
        public static final int TYPE_HTML = 0;
        public static final int TYPE_JSON = 1;
        public static final int TYPE_PDF = 2;
        public static final int TYPE_MP4 = 3;
        private final int type;
        private final String dir;
        private final String name;
        private Class clazz;

        public Resource(int type, String dir, String name) {
            this(type, dir, name, null);
        }

        public Resource(int type, String dir, String name, Class clazz) {
            this.type = type;
            this.dir = dir;
            this.name = name;
            this.clazz = clazz;
        }

        public String getDir() {
            return this.dir;
        }

        public String getName() {
            return this.name;
        }

        public int getType() {
            return this.type;
        }

        public <T> T create(Context context) {
            String path = this.getRelativePath();
            return ResourcePathManager.getResourceAsClass(context, this.clazz, path);
        }

        public InputStream open(Context context) {
            String path = this.getRelativePath();
            return ResourcePathManager.getResouceAsInputStream(context, path);
        }

        public String getAbsolutePath() {
            return "file:///android_asset/" + this.getRelativePath();
        }

        public String getRelativePath() {
            StringBuilder path = new StringBuilder();
            if (!TextUtils.isEmpty((CharSequence)this.dir)) {
                path.append(this.dir).append("/");
            }
            return path.append(this.name).append(".").append(this.getFileExtension()).toString();
        }

        public String getFileExtension() {
            return ResourcePathManager.getInstance().getFileExtension(this.type);
        }
    }
}

