package org.researchstack.backbone.result;

import android.net.Uri;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/**
 * An TaskResult object is a result that contains all the step results generated from one run of a
 * task or ordered task (that is, {@link org.researchstack.backbone.task.Task} or {@link
 * org.researchstack.backbone.task.OrderedTask}).
 * <p>
 * A task result is typically generated by the framework as the task proceeds. When the task
 * completes, it may be appropriate to serialize it for transmission to a server, or to immediately
 * perform analysis on it.
 * <p>
 * The <code>results</code> property contains the step results for the task.
 */
public class TaskResult extends Result
{
    private Map<String, StepResult> results;

    // unimplemented but exists in RK, implement or delete if not needed
    private UUID uuidTask;

    // unimplemented but exists in RK, implement or delete if not needed
    private Uri outputDirectory;

    public TaskResult(String identifier)
    {
        super(identifier);
        this.results = new HashMap<>();
    }

    /**
     * Returns a Map of all of the StepResults in the task.
     *
     * @return a Map of the StepResults
     */
    public Map<String, StepResult> getResults()
    {
        return results;
    }

    /**
     * Returns a step result for the specified step identifier, if one exists.
     *
     * @param identifier The identifier for which to search.
     * @return The result for the specified step, or {@link nil} for none.
     */
    public StepResult getStepResult(String identifier)
    {
        return results.get(identifier);
    }

    /**
     * Sets the result for the step using the step's identifier as a key.
     *
     * @param identifier the Step and StepResult's identifier
     * @param stepResult the StepResult for this identifier
     */
    public void setStepResultForStepIdentifier(String identifier, StepResult stepResult)
    {
        results.put(identifier, stepResult);
    }
}
