package org.findmykids.geo.presentation.manage

import android.content.ContentProvider
import android.content.ContentResolver
import android.content.ContentValues
import android.database.Cursor
import android.database.MatrixCursor
import android.net.Uri
import org.findmykids.geo.api.model.GeoPlatformState
import org.findmykids.geo.common.di.DIScopeHolder
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.domain.authorization.AuthorizationInteractor
import javax.inject.Inject


/**
 * Провайдер у которого узнаем активировано ли гео
 */
internal class AuthorityCheckProvider : ContentProvider() {

    @Inject
    lateinit var mAuthorizationInteractor: AuthorizationInteractor


    override fun toString(): String = ""


    override fun onCreate(): Boolean {
        Logger.d().print()
        DIScopeHolder.createRootScope(context!!).inject(this)
        return true
    }


    override fun getType(uri: Uri): String? =
        ContentResolver.CURSOR_ITEM_BASE_TYPE + "/vnd." + NAME + ".item"

    override fun query(
        uri: Uri,
        projection: Array<out String>?,
        selection: String?,
        selectionArgs: Array<out String>?,
        sortOrder: String?
    ): Cursor? {
        Logger.d().print()
        val result = if (selectionArgs == null) {
            GeoPlatformState.ERROR()
        } else if (selectionArgs.size != 2) {
            GeoPlatformState.ERROR()
        } else {
            val isActivated = mAuthorizationInteractor
                .isActivated()
                .blockingGet()
            if (isActivated) {
                val baseUrl = mAuthorizationInteractor
                    .getBaseUrl()
                    .blockingGet()
                if (baseUrl.value == null) {
                    GeoPlatformState.ERROR()
                } else {
                    val userId = mAuthorizationInteractor
                        .getUserId()
                        .blockingGet()
                    if (userId.value == null) {
                        GeoPlatformState.ERROR()
                    } else {
                        when {
                            baseUrl.value != selectionArgs.component1() -> GeoPlatformState.ACTIVATED_TO_ANOTHER_URL
                            String(userId.value) != selectionArgs.component2() -> GeoPlatformState.ACTIVATED_TO_ANOTHER_USER_ID
                            else -> GeoPlatformState.ACTIVATED
                        }
                    }
                }
            } else {
                GeoPlatformState.DEACTIVATED
            }
        }
        val cursor = MatrixCursor(arrayOf("value"))
        val rowBuilder = cursor.newRow()
        rowBuilder.add(result.value)
        return cursor
    }

    override fun insert(uri: Uri, values: ContentValues?): Uri? =
        throw NotImplementedError()

    override fun update(uri: Uri, values: ContentValues?, selection: String?, selectionArgs: Array<out String>?): Int =
        throw NotImplementedError()

    override fun delete(uri: Uri, selection: String?, selectionArgs: Array<out String>?): Int =
        throw NotImplementedError()


    companion object {
        const val NAME = "AuthorityCheckProvider"
    }
}