package org.findmykids.geo.domain.authorization

import io.reactivex.Completable
import io.reactivex.Single
import org.findmykids.geo.common.Container
import org.findmykids.geo.data.repository.storage.authorisation.AuthorisationRepository
import org.findmykids.geo.domain.BaseInteractor
import javax.inject.Inject


internal class AuthorizationInteractorImpl @Inject constructor(
    private val mAuthorisationRepository: AuthorisationRepository
) : BaseInteractor(), AuthorizationInteractor {

    override fun toString(): String = ""

    override fun activate(baseUrl: String, apiKey: CharArray, userToken: CharArray, userId: CharArray): Completable = mAuthorisationRepository
        .set(baseUrl, apiKey, userToken, userId)

    override fun deactivate(): Completable = mAuthorisationRepository
        .clear()

    override fun isActivated(): Single<Boolean> = mAuthorisationRepository
        .isAuthorised()

    override fun getBaseUrl(): Single<Container<String>> = mAuthorisationRepository
        .getBaseUrl()

    override fun getUserId(): Single<Container<CharArray>> = mAuthorisationRepository
        .getUserId()
}