package org.findmykids.geo.data.repository.trigger.zones.huawei

import android.app.PendingIntent
import android.content.Context
import android.content.Intent
import com.huawei.hmf.tasks.Tasks
import com.huawei.hms.location.Geofence
import com.huawei.hms.location.GeofenceRequest
import com.huawei.hms.location.LocationServices
import io.reactivex.Completable
import io.reactivex.Single
import org.findmykids.geo.common.GeoException
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.data.model.Zones
import org.findmykids.geo.data.repository.trigger.zones.ZonesManager
import java.util.concurrent.TimeUnit
import javax.inject.Inject


// TODO Зоны безопасности
internal class ZonesHuaweiManagerImpl @Inject constructor(
    private val mContext: Context
) : ZonesManager {

    override fun toString(): String = ""

    override fun isSubscribed(): Single<Boolean> = Single
        .fromCallable {
            Logger.d().with(this@ZonesHuaweiManagerImpl).print()
            getIntent(PendingIntent.FLAG_NO_CREATE) != null
        }
        .doOnSuccess {
            Logger.i().setResult(it).with(this@ZonesHuaweiManagerImpl).print()
        }

    override fun subscribe(zones: Zones): Completable = Single
        .fromCallable {
            Logger.d().with(this@ZonesHuaweiManagerImpl).print()
            if (zones.zones.isNotEmpty()) {
                Logger.d("has zones").with(this@ZonesHuaweiManagerImpl).print()
                getIntent(PendingIntent.FLAG_UPDATE_CURRENT)?.let { intent ->
                    Logger.d("has intent").with(this@ZonesHuaweiManagerImpl).print()
                    val geofencingRequest = GeofenceRequest.Builder()
                        .setInitConversions(GeofenceRequest.ENTER_INIT_CONVERSION or GeofenceRequest.EXIT_INIT_CONVERSION)
                        .createGeofenceList(zones.zones.map {
                            Geofence.Builder()
                                .setConversions(Geofence.ENTER_GEOFENCE_CONVERSION or Geofence.EXIT_GEOFENCE_CONVERSION)
                                .setRoundArea(it.lat, it.lon, it.radius)
                                .setUniqueId(it.id)
                                .setValidContinueTime(Geofence.GEOFENCE_NEVER_EXPIRE)
                                .build()
                        })
                        .build()
                    try {
                        Tasks.await(LocationServices.getGeofenceService(mContext).createGeofenceList(geofencingRequest, intent), 10, TimeUnit.SECONDS)
                        true
                    } catch (e: Exception) {
                        Logger.e(GeoException.ZoneSubscription(e)).with(this@ZonesHuaweiManagerImpl).print()
                        false
                    }
                } ?: false
            } else {
                false
            }
        }
        .doOnSuccess {
            Logger.i().setResult(it).with(this@ZonesHuaweiManagerImpl).print()
        }
        .ignoreElement()

    override fun unsubscribe(): Completable = Single
        .fromCallable {
            Logger.d().with(this@ZonesHuaweiManagerImpl).print()
            getIntent(PendingIntent.FLAG_NO_CREATE)?.let { intent ->
                Logger.d("has intent").with(this@ZonesHuaweiManagerImpl).print()
                try {
                    Tasks.await(LocationServices.getGeofenceService(mContext).deleteGeofenceList(intent), 10, TimeUnit.SECONDS)
                    true
                } catch (e: Exception) {
                    Logger.e(GeoException.ZoneUnSubscription(e)).with(this@ZonesHuaweiManagerImpl).print()
                    false
                } finally {
                    intent.cancel()
                }
            } ?: true
        }
        .doOnSuccess {
            Logger.i().setResult(it).with(this@ZonesHuaweiManagerImpl).print()
        }
        .ignoreElement()


    private fun getIntent(flags: Int): PendingIntent? {
        Logger.d().print()
        val intent = Intent(mContext, ZonesHuaweiReceiver::class.java)
        intent.addFlags(Intent.FLAG_INCLUDE_STOPPED_PACKAGES)
        return PendingIntent.getBroadcast(mContext, REQUEST_ZONES_HUAWEI, intent, flags)
    }


    companion object {
        private const val REQUEST_ZONES_HUAWEI = 6748610
    }
}