package org.findmykids.geo.data.repository.trigger.zones.google

import android.content.Context
import android.content.Intent
import com.google.android.gms.location.GeofencingEvent
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.data.repository.trigger.zones.BaseZonesReceiver
import org.findmykids.geo.data.repository.trigger.zones.ZoneEventFactory


// TODO Зоны безопасности
internal class ZonesGoogleReceiver : BaseZonesReceiver() {
    override fun onReceive(context: Context, intent: Intent) {
        Logger.d().print()
        GeofencingEvent.fromIntent(intent)?.let {
            Logger.d().addArg(it).with(this@ZonesGoogleReceiver).print()
            send(context, ZoneEventFactory.createFromGeofencingEvent(it))
        }
    }
}