package org.findmykids.geo.data.repository.trigger.passive.locationmanager

import android.content.Context
import android.content.Intent
import android.location.Location
import android.location.LocationManager
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.data.model.LocationSource
import org.findmykids.geo.data.repository.live.location.LocationFactory
import org.findmykids.geo.data.repository.trigger.passive.BasePassiveReceiver


internal class PassiveLocationManagerReceiver : BasePassiveReceiver() {
    override fun onReceive(context: Context, intent: Intent) {
        Logger.d().print()
        intent.getParcelableExtra<Location>(LocationManager.KEY_LOCATION_CHANGED)?.let {
            Logger.d().addArg(it).with(this@PassiveLocationManagerReceiver).print()
            send(context, LocationFactory.createLocation(it, LocationSource.LOCATION_MANAGER))
        }
    }
}