package org.findmykids.geo.data.repository.trigger.activity.huawei

import android.content.Context
import android.content.Intent
import com.huawei.hms.location.ActivityConversionResponse
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.data.repository.trigger.activity.ActivityEventFactory
import org.findmykids.geo.data.repository.trigger.activity.BaseActivityReceiver


internal class ActivityHuaweiReceiver : BaseActivityReceiver() {
    override fun onReceive(context: Context, intent: Intent) {
        Logger.d().print()
        val results = ActivityConversionResponse.getDataFromIntent(intent)
        val events = results?.activityConversionDatas
        if (events != null && events.isNotEmpty()) {
            Logger.d().addArg(events).with(this@ActivityHuaweiReceiver).print()
            send(context, ActivityEventFactory.createFromConversion(events))
        }
    }
}