package org.findmykids.geo.data.repository.storage.currentSession

import io.reactivex.Completable
import io.reactivex.Single
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.data.model.CommandType
import org.findmykids.geo.data.model.Session
import org.findmykids.geo.data.preferences.LocalPreferences
import java.util.*
import javax.inject.Inject


internal class CurrentSessionRepositoryImpl @Inject constructor(
    private val mLocalPreferences: LocalPreferences
) : CurrentSessionRepository {

    private val mCreated = Date()
    @Volatile
    private var mIsRealtime: Boolean = false
    private val mCommandsTypes = mutableListOf<CommandType>()


    override fun toString(): String = ""

    override fun setRealtime(isRealtime: Boolean): Completable = Completable
        .fromCallable {
            Logger.d().addArg(isRealtime).with(this@CurrentSessionRepositoryImpl).print()
            mIsRealtime = isRealtime
            Unit
        }
        .doOnComplete {
            Logger.d("Complete").with(this@CurrentSessionRepositoryImpl).print()
        }

    override fun addCommandType(commandType: CommandType): Completable = Completable
        .fromCallable {
            Logger.d().addArg(commandType).with(this@CurrentSessionRepositoryImpl).print()
            synchronized(mCommandsTypes) {
                mCommandsTypes.add(commandType)
            }
        }
        .doOnComplete {
            Logger.d("Complete").with(this@CurrentSessionRepositoryImpl).print()
        }

    override fun getSession(): Single<Session> = Single
        .fromCallable {
            Logger.d().with(this@CurrentSessionRepositoryImpl).print()
            synchronized(mCommandsTypes) {
                Session(
                    mLocalPreferences.getSessionIndex(mCreated),
                    mCreated,
                    mIsRealtime,
                    mCommandsTypes.toList()
                )
            }
        }
        .doOnSuccess {
            Logger.d().setResult(it).with(this@CurrentSessionRepositoryImpl).print()
        }
}