package org.findmykids.geo.data.repository.storage.authorisation

import io.reactivex.Completable
import io.reactivex.Single
import org.findmykids.geo.common.Container
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.data.preferences.LocalPreferences
import javax.inject.Inject


internal class AuthorisationRepositoryImpl @Inject constructor(
    private val mLocalPreferences: LocalPreferences
) : AuthorisationRepository {

    private val mLock = Any()


    override fun toString(): String = ""

    override fun set(baseUrl: String, apiKey: CharArray, userToken: CharArray, userId: CharArray): Completable = Completable
        .fromCallable {
            Logger.d().addArg(baseUrl).addArg(userId).with(this@AuthorisationRepositoryImpl).print()
            synchronized(mLock) {
                mLocalPreferences.apply {
                    setBaseUrl(baseUrl)
                    setApiKey(apiKey)
                    setUserToken(userToken)
                    setUserId(userId)
                }
            }
        }
        .doOnComplete {
            Logger.d("Complete").with(this@AuthorisationRepositoryImpl).print()
        }

    override fun isAuthorised(): Single<Boolean> = Single
        .fromCallable {
            Logger.d().with(this@AuthorisationRepositoryImpl).print()
            synchronized(mLock) {
                mLocalPreferences.run {
                    getBaseUrl() != null && getApiKey() != null && getUserToken() != null && getUserId() != null
                }
            }
        }
        .doOnSuccess {
            Logger.d().setResult(it).with(this@AuthorisationRepositoryImpl).print()
        }

    override fun getBaseUrl(): Single<Container<String>> = Single
        .fromCallable {
            Logger.d().with(this@AuthorisationRepositoryImpl).print()
            synchronized(mLock) {
                Container(mLocalPreferences.getBaseUrl())
            }
        }
        .doOnSuccess {
            Logger.d().setResult(it).with(this@AuthorisationRepositoryImpl).print()
        }

    override fun getUserId(): Single<Container<CharArray>> = Single
        .fromCallable {
            Logger.d().with(this@AuthorisationRepositoryImpl).print()
            synchronized(mLock) {
                Container(mLocalPreferences.getUserId())
            }
        }
        .doOnSuccess {
            Logger.d("Complete").with(this@AuthorisationRepositoryImpl).print()
        }

    override fun clear(): Completable = Completable
        .fromCallable {
            Logger.d().with(this@AuthorisationRepositoryImpl).print()
            synchronized(mLock) {
                mLocalPreferences.apply {
                    setBaseUrl(null)
                    setApiKey(null)
                    setUserToken(null)
                    setUserId(null)
                }
            }
        }
        .doOnComplete {
            Logger.d("Complete").with(this@AuthorisationRepositoryImpl).print()
        }
}