package org.findmykids.geo.data.repository.live.location

import android.Manifest
import android.content.Context
import android.location.Location
import android.location.LocationListener
import android.location.LocationManager
import android.os.Bundle
import android.os.HandlerThread
import androidx.annotation.RequiresPermission
import androidx.core.content.ContextCompat
import org.findmykids.geo.common.GeoException
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.common.utils.LocationManagerUtil
import org.findmykids.geo.data.model.Configuration
import org.findmykids.geo.data.model.LocationSource


internal class LocationSourceProviderGpsProviderImpl(
    private val mContext: Context,
    private val mCallback: LocationSourceProvider.Callback,
    private val mHandlerThread: HandlerThread
) : LocationSourceProvider {

    private val mLocationListener = object : LocationListener {
        override fun onLocationChanged(location: Location) {
            Logger.d().with(this@LocationSourceProviderGpsProviderImpl).print()
            mCallback.onLocation(LocationFactory.createLocation(location, LocationSource.LOCATION_MANAGER))
        }

        override fun onStatusChanged(provider: String, status: Int, extras: Bundle) {
            Logger.d().with(this@LocationSourceProviderGpsProviderImpl).print()
        }

        override fun onProviderEnabled(provider: String) {
            Logger.d().with(this@LocationSourceProviderGpsProviderImpl).print()
        }

        override fun onProviderDisabled(provider: String) {
            Logger.d().with(this@LocationSourceProviderGpsProviderImpl).print()
        }
    }


    override fun toString(): String = ""

    @RequiresPermission(anyOf = [Manifest.permission.ACCESS_COARSE_LOCATION, Manifest.permission.ACCESS_FINE_LOCATION])
    override fun start(configuration: Configuration.LocationDataConfiguration) {
        Logger.d().addArg(configuration).print()
        if (LocationManagerUtil.isGpsEnabled(ContextCompat.getSystemService(mContext, LocationManager::class.java)!!)) {
            ContextCompat.getSystemService(mContext, LocationManager::class.java)!!.requestLocationUpdates(
                LocationManager.GPS_PROVIDER,
                configuration.maxWaitTime,
                configuration.smallestDisplacement,
                mLocationListener,
                mHandlerThread.looper
            )
        } else {
            throw GeoException.GpsProviderLocationManagerGpsIsNotEnabled()
        }
    }

    override fun stop() {
        Logger.d().print()
        ContextCompat.getSystemService(mContext, LocationManager::class.java)!!.removeUpdates(mLocationListener)
    }
}