package org.findmykids.geo.data.repository.live.activity

import com.google.android.gms.location.ActivityRecognitionResult
import com.huawei.hms.location.ActivityIdentificationResponse
import org.findmykids.geo.data.model.Activity
import org.findmykids.geo.data.model.ActivityType


internal object ActivityFactory {
    fun create(activityRecognitionResult: ActivityRecognitionResult) = Activity(
        activityRecognitionResult.elapsedRealtimeMillis,
        activityRecognitionResult.time,
        activityRecognitionResult.probableActivities.let { activities ->
            val result = hashMapOf<ActivityType, Int>()
            activities.map {
                result.put(ActivityType.toActivityType(it.type), it.confidence)
            }
            result
        })

    fun create(activityIdentificationResponse: ActivityIdentificationResponse) = Activity(
        activityIdentificationResponse.elapsedTimeFromReboot,
        activityIdentificationResponse.time,
        activityIdentificationResponse.activityIdentificationDatas.let { activities ->
            val result = hashMapOf<ActivityType, Int>()
            activities.map {
                result.put(ActivityType.toActivityType(it.identificationActivity - 100), it.possibility)
            }
            result
        })
}