package org.findmykids.geo.data.preferences

import android.content.SharedPreferences
import org.findmykids.geo.common.logger.Logger
import java.util.*
import javax.inject.Inject


internal class LocalPreferencesImpl @Inject constructor(
    private val mSharedPreferences: SharedPreferences
) : LocalPreferences {

    override fun toString(): String = ""


    override fun setBaseUrl(baseUrl: String?) {
        Logger.d().print()
        mSharedPreferences.edit().putString(FIELD_BASE_URL, baseUrl).apply()
    }

    override fun getBaseUrl(): String? {
        val baseUrl = mSharedPreferences.getString(FIELD_BASE_URL, null)
        Logger.d().setResult(baseUrl).print()
        return baseUrl
    }


    override fun setApiKey(apiKey: CharArray?) {
        Logger.d().print()
        mSharedPreferences.edit().putCharArray(FIELD_API_KEY, apiKey).apply()
    }

    override fun getApiKey(): CharArray? {
        val apiKey = mSharedPreferences.getString(FIELD_API_KEY, null)?.toCharArray()
        Logger.d().print()
        return apiKey
    }


    override fun setUserToken(userToken: CharArray?) {
        Logger.d().print()
        mSharedPreferences.edit().putCharArray(FIELD_USER_TOKEN, userToken).apply()
    }

    override fun getUserToken(): CharArray? {
        val userToken = mSharedPreferences.getString(FIELD_USER_TOKEN, null)?.toCharArray()
        Logger.d().print()
        return userToken
    }


    override fun setUserId(userId: CharArray?) {
        Logger.d().addArg(userId).print()
        mSharedPreferences.edit().putCharArray(FIELD_USER_ID, userId).apply()
    }

    override fun getUserId(): CharArray? {
        val userId = mSharedPreferences.getString(FIELD_USER_ID, null)?.toCharArray()
        Logger.d().setResult(userId).print()
        return userId
    }


    override fun setTimerUUID(uuid: UUID?) {
        Logger.d().addArg(uuid).print()
        mSharedPreferences.edit().putString(FIELD_TIMER_UUID, uuid?.toString()).apply()
    }

    override fun getTimerUUID(): UUID? {
        val uuid = mSharedPreferences.getString(FIELD_TIMER_UUID, null)
        Logger.d().setResult(uuid).print()
        return uuid?.let {
            UUID.fromString(it)
        }
    }


    override fun setLastWifiScanTime(date: Date) {
        Logger.d().addArg(date).print()
        mSharedPreferences.edit().putLong(FIELD_LAST_WIFI_SCAN_TIME, date.time).apply()
    }

    override fun getLastWifiScanTime(): Date {
        val time = Date(mSharedPreferences.getLong(FIELD_LAST_WIFI_SCAN_TIME, 0L))
        Logger.d().setResult(time).print()
        return time
    }


    override fun setLastLbsScanTime(date: Date) {
        Logger.d().addArg(date).print()
        mSharedPreferences.edit().putLong(FIELD_LAST_LBS_SCAN_TIME, date.time).apply()
    }

    override fun getLastLbsScanTime(): Date {
        val time = Date(mSharedPreferences.getLong(FIELD_LAST_LBS_SCAN_TIME, 0L))
        Logger.d().setResult(time).print()
        return time
    }


    @Synchronized
    override fun getSessionIndex(created: Date): Long {
        val lastSessionDate = mSharedPreferences.getLong(FIELD_LAST_SESSION_DATE, 0L)
        val sessionIndex = mSharedPreferences.getLong(FIELD_SESSION_INDEX, 0L)
        return if (lastSessionDate == created.time) {
            sessionIndex
        } else {
            mSharedPreferences.edit()
                .putLong(FIELD_LAST_SESSION_DATE, created.time)
                .putLong(FIELD_SESSION_INDEX, sessionIndex + 1)
                .apply()
            sessionIndex + 1
        }
    }

    override fun getAndIncreaseDefineGlobalIndex(): Long {
        val value = mSharedPreferences.getLong(FIELD_DEFINE_GLOBAL_INDEX, 1)
        mSharedPreferences.edit().putLong(FIELD_DEFINE_GLOBAL_INDEX, value + 1).apply()
        return value
    }

    override fun getAndIncreaseSendGlobalIndex(): Long {
        val value = mSharedPreferences.getLong(FIELD_SEND_GLOBAL_INDEX, 1)
        mSharedPreferences.edit().putLong(FIELD_SEND_GLOBAL_INDEX, value + 1).apply()
        return value
    }


    private fun SharedPreferences.Editor.putCharArray(key: String, charArray: CharArray?): SharedPreferences.Editor {
        putString(key, charArray?.let { String(it) })
        return this
    }



    companion object {
        private const val FIELD_BASE_URL = "BaseUrl"
        private const val FIELD_API_KEY = "ApiKeyCharArray"
        private const val FIELD_USER_TOKEN = "UserTokenCharArray"
        private const val FIELD_USER_ID = "UserIdCharArray"
        private const val FIELD_TIMER_UUID = "TimerUUID"
        private const val FIELD_LAST_WIFI_SCAN_TIME = "LastWifiScanTime"
        private const val FIELD_LAST_LBS_SCAN_TIME = "LastLbsScanTime"
        private const val FIELD_LAST_SESSION_DATE = "LastSessionDate"
        private const val FIELD_SESSION_INDEX = "SessionIndex"
        private const val FIELD_DEFINE_GLOBAL_INDEX = "DefineGlobalIndex"
        private const val FIELD_SEND_GLOBAL_INDEX = "SendGlobalIndex"
    }
}