package org.findmykids.geo.data.network.factory

import geoproto.Coords
import org.findmykids.geo._todo.Geo
import org.findmykids.geo.api.extensions.GeoExtensions
import org.findmykids.geo.data.model.Error
import org.findmykids.geo.data.model.SendGeoLocation


internal object CoordsFactory {
    fun createCoords(isOnline: Boolean, vararg geos: Geo): Coords = Coords
        .newBuilder()
        .setIsOfline(!isOnline)
        .apply {
            addAllCoord(geos.map { geo ->
                when (geo) {
                    is Geo.LbsLocatorLocationGeo -> CoordFactory.createCoord(geo)
                    is Geo.LbsLocatorErrorGeo -> CoordFactory.createCoord(geo)
                    is Geo.WifiLocatorLocationGeo -> CoordFactory.createCoord(geo)
                    is Geo.WifiLocatorErrorGeo -> CoordFactory.createCoord(geo)
                }
            })
        }
        .build()

    fun createCoords(isOnline: Boolean, vararg errors: Error): Coords = Coords
        .newBuilder()
        .setIsOfline(!isOnline)
        .apply {
            addAllCoord(errors.map { error ->
                CoordFactory.createCoord(error)
            })
        }
        .build()

    fun createCoords(geoExtensions: GeoExtensions, isOnline: Boolean, vararg sendGeoLocations: SendGeoLocation): Coords = Coords
        .newBuilder()
        .setIsOfline(!isOnline)
        .apply {
            addAllCoord(sendGeoLocations.map { sendGeoLocation ->
                CoordFactory.createCoord(sendGeoLocation, geoExtensions)
            })
        }
        .build()
}