package org.findmykids.geo.data.model

import kotlin.math.pow
import kotlin.math.sqrt


internal data class Sensors(
    val absAcceleration: List<Float>,
    val nowMs: Long
) {
    override fun toString(): String {
        return "${this::class.simpleName}(" +
                "${this::class.java.declaredFields[0].name}=$absAcceleration, " +
                "${this::class.java.declaredFields[1].name}=$nowMs)"
    }


    fun getLength() = sqrt(
        absAcceleration[EAST].toDouble().pow(2.0) +
                absAcceleration[NORTH].toDouble().pow(2.0) +
                absAcceleration[UP].toDouble().pow(2.0)
    )


    companion object {
        const val EAST = 0
        const val NORTH = 1
        const val UP = 2
    }
}