package org.findmykids.geo.data.db.model

import androidx.room.Entity
import androidx.room.PrimaryKey
import androidx.room.TypeConverters
import org.findmykids.geo.data.db.converter.*
import org.findmykids.geo.data.model.ActivityType
import org.findmykids.geo.data.model.CommandType
import org.findmykids.geo.data.model.GpsInfo
import org.findmykids.geo.data.model.LocationSource
import java.util.*


@Entity
@TypeConverters(
    DateConverter::class,
    SessionCommandsTypesListConverter::class,
    LocationSourceConverter::class,
    GpsInfoSatellitesInfosListConverter::class,
    ActivityTypesWithConfidencesMapConverter::class,
    ExtensionsConverter::class
)
internal data class SendGeoLocationEntity(
    @PrimaryKey(autoGenerate = true)
    val id: Int = 0,

    val create: Date,

    val sessionIndex: Long,
    val sessionCreate: Date,
    val sessionIsRealtime: Boolean,
    val sessionCommandsTypes: List<CommandType>,

    val locationLatitude: Double,
    val locationLongitude: Double,
    val locationProvider: String,
    val locationTime: Long,
    val locationAltitude: Double?,
    val locationAccuracy: Float?,
    val locationBearing: Float?,
    val locationElapsedRealtimeUncertaintyNanos: Double?,
    val locationSpeed: Float?,
    val locationSpeedAccuracyMetersPerSecond: Float?,
    val locationVerticalAccuracyMeters: Float?,
    val locationBearingAccuracyDegrees: Float?,
    val locationElapsedRealtimeNanos: Long?,
    val locationSource: LocationSource,
    val locationDefineSessionIndex: Long,
    val locationDefineGlobalIndex: Long,

    val calculatedLocationExist: Boolean,
    val calculatedLocationLatitude: Double?,
    val calculatedLocationLongitude: Double?,
    val calculatedLocationAltitude: Double?,
    val calculatedLocationSpeed: Double?,

    val gpsInfoExist: Boolean,
    val gpsInfoTimeToFirstFix: Int?,
    val gpsInfoMaxSatellites: Int?,
    val gpsInfoSatellites: List<GpsInfo.SatelliteInfo>?,

    val activityExist: Boolean,
    val activityElapsedRealtimeMillis: Long?,
    val activityTime: Long?,
    val activityActivitiesWithConfidences: Map<ActivityType, Int>?,

    val batteryExist: Boolean,
    val batteryIsCharging: Boolean?,
    val batteryLevel: Int?,

    val wifiExist: Boolean,
    val wifiSsid: String?,
    val wifiMac: String?,
    val wifiLevel: Int?,

    val sendReason: String,
    val sendSessionIndex: Long,
    val sendGlobalIndex: Long,

    val extensions: Map<String, String>
) {
    override fun toString(): String = ""
}