package org.findmykids.geo.data.db.dao

import androidx.room.*
import org.findmykids.geo.data.db.model.SendGeoLocationEntity


@Dao
internal interface SendGeoLocationsDao {
    @Query("SELECT COUNT(id) FROM SendGeoLocationEntity")
    fun getRowCount(): Int

    @Query("SELECT * FROM SendGeoLocationEntity WHERE sessionIndex = :sessionIndex AND :nowTime - sessionCreate < 60000")
    fun selectOnline(sessionIndex: Long, nowTime: Long): List<SendGeoLocationEntity>

    @Query("SELECT * FROM SendGeoLocationEntity LIMIT :limit")
    fun select(limit: Int): List<SendGeoLocationEntity>

    @Insert(onConflict = OnConflictStrategy.ABORT)
    fun insert(sendGeoLocationEntity: SendGeoLocationEntity)

    @Delete
    fun delete(sendGeoLocationEntity: SendGeoLocationEntity)

    @Query("DELETE FROM SendGeoLocationEntity")
    fun deleteAll()
}