package org.findmykids.geo.data.db.converter

import androidx.room.TypeConverter
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import org.findmykids.geo.data.model.GpsInfo


internal class GpsInfoSatellitesInfosListConverter {
    @TypeConverter
    fun to(list: String?): List<GpsInfo.SatelliteInfo>? {
        return if (list == null) {
            null
        } else {
            Gson().fromJson(list, object : TypeToken<List<GpsInfo.SatelliteInfo>?>() {}.type)
        }
    }

    @TypeConverter
    fun from(list: List<GpsInfo.SatelliteInfo>?): String? {
        return if (list == null) {
            null
        } else {
            Gson().toJson(list, object : TypeToken<List<GpsInfo.SatelliteInfo>?>() {}.type)
        }
    }
}