package org.findmykids.geo.data.db.converter

import androidx.room.TypeConverter
import com.google.gson.Gson
import com.google.gson.JsonObject
import org.findmykids.geo.common.GeoException
import org.findmykids.geo.data.model.Configuration


internal class ConfigurationConverter {
    @TypeConverter
    fun toConfiguration(jsonString: String): Configuration {
        val json = GSON.fromJson(jsonString, JsonObject::class.java)
        val cls = when (val type = json.get(FIELD_TYPE).asInt) {
            Configuration.Type.ACTIVITY.value -> Configuration.ActivityConfiguration::class.java
            Configuration.Type.PASSIVE.value -> Configuration.PassiveConfiguration::class.java
            Configuration.Type.STATION.value -> Configuration.StationConfiguration::class.java
            Configuration.Type.TIMER.value -> Configuration.TimerConfiguration::class.java
            Configuration.Type.LOCATION_DATA.value -> Configuration.LocationDataConfiguration::class.java
            Configuration.Type.GPS_DATA.value -> Configuration.GpsDataConfiguration::class.java
            Configuration.Type.BATTERY_DATA.value -> Configuration.BatteryDataConfiguration::class.java
            Configuration.Type.LBS_DATA.value -> Configuration.LbsDataConfiguration::class.java
            Configuration.Type.REMOTE_DATA.value -> Configuration.RemoteDataConfiguration::class.java
            Configuration.Type.SENSORS_DATA.value -> Configuration.SensorsDataConfiguration::class.java
            Configuration.Type.TIMEOUT_DATA.value -> Configuration.TimeoutDataConfiguration::class.java
            Configuration.Type.WIFI_DATA.value -> Configuration.WifiDataConfiguration::class.java
            Configuration.Type.ACTIVITY_DATA.value -> Configuration.ActivityDataConfiguration::class.java
            Configuration.Type.GEO_STORAGE.value -> Configuration.GeoStorageConfiguration::class.java
            Configuration.Type.ERROR_STORAGE.value -> Configuration.ErrorStorageConfiguration::class.java
            Configuration.Type.LOCATION_LIVE.value -> Configuration.LocationLiveConfiguration::class.java
            Configuration.Type.LOCATOR_LIVE.value -> Configuration.LocatorLiveConfiguration::class.java
            else -> throw GeoException.InvalidConfigurationType(type)
        }
        return GSON.fromJson(json.get(FIELD_OBJECT).asString, cls) as Configuration
    }

    @TypeConverter
    fun fromConfiguration(configuration: Configuration): String {
        val json = JsonObject()
        json.addProperty(FIELD_TYPE, configuration.type)
        json.addProperty(FIELD_OBJECT, GSON.toJson(configuration))
        return json.toString()
    }


    companion object {
        private const val FIELD_TYPE = "type"
        private const val FIELD_OBJECT = "object"

        private val GSON = Gson()
    }
}