package org.findmykids.geo.common.utils

import android.annotation.SuppressLint
import android.content.Context
import android.os.Build
import com.google.android.gms.common.ConnectionResult
import com.google.android.gms.common.GoogleApiAvailability
import java.util.*


object ManufactureUtil {
    private const val EMUI_NAME = "ro.build.version.emui"


    fun isXiaomiNoGoogleOne(): Boolean = when {
        "Xiaomi".equals(Build.BRAND, true) -> !("Mi A2".equals(Build.MODEL, true) ||
                "Mi A2 Lite".equals(Build.MODEL, true) ||
                "Mi A1".equals(Build.MODEL, true))
        else -> false
    }

    @SuppressLint("DefaultLocale")
    fun isHuawei() = Build.MANUFACTURER.toLowerCase(Locale.ENGLISH) == "huawei" ||
            Build.MANUFACTURER.toLowerCase(Locale.ENGLISH) == "honor" ||
            Build.MANUFACTURER.toLowerCase() == "هواوي" ||
            Build.MANUFACTURER.toLowerCase(Locale.CHINA) == "華為" ||
            Build.MANUFACTURER.toLowerCase(Locale.CHINESE) == "華為" ||
            Build.MANUFACTURER.toLowerCase() == "هواوی" ||
            Build.MANUFACTURER.toLowerCase() == "हुवावे" ||
            Build.MANUFACTURER.toLowerCase(Locale.KOREA) == "화웨이" ||
            Build.MANUFACTURER.toLowerCase(Locale.KOREAN) == "화웨이" ||
            Build.MANUFACTURER.toLowerCase() == "havai" ||
            Build.MANUFACTURER.toLowerCase(Locale.CHINA) == "华为" ||
            Build.MANUFACTURER.toLowerCase(Locale.CHINESE) == "华为"

    fun isEmuiVersion9_1orAfter(): Boolean {
        val version = getEmuiVersion()
        return when {
            version[0] > 9 -> true
            version[0] == 9 -> version[1] >= 1
            else -> false
        }
    }

    fun isEmuiVersion9_1_1orAfter(): Boolean {
        val version = getEmuiVersion()
        return when {
            version[0] > 9 -> true
            version[0] == 9 -> when {
                version[1] > 1 -> true
                version[1] == 1 -> version[2] >= 1
                else -> false
            }
            else -> false
        }
    }

    fun isEmuiVersion10orAfter(): Boolean {
        val version = getEmuiVersion()
        return version[0] >= 10
    }

    private fun getEmuiVersion(): IntArray {
        val version = getSystemProperty(EMUI_NAME).replace("EmotionUI_", "").trim()
        val split = version.split(".")
        return when {
            split.isEmpty() -> intArrayOf(0, 0, 0)
            split.size == 1 -> intArrayOf(split[0].toIntOrNull() ?: 0, 0, 0)
            split.size == 2 -> intArrayOf(split[0].toIntOrNull() ?: 0, split[1].toIntOrNull() ?: 0, 0)
            else -> intArrayOf(split[0].toIntOrNull() ?: 0, split[1].toIntOrNull() ?: 0, split[2].toIntOrNull() ?: 0)
        }
    }

    @SuppressLint("PrivateApi")
    private fun getSystemProperty(key: String): String {
        return try {
            val clz = Class.forName("android.os.SystemProperties")
            val get = clz.getMethod("get", String::class.java, String::class.java)
            get.invoke(clz, key, "") as String
        } catch (e: Exception) {
            e.printStackTrace()
            ""
        }
    }

    fun isPlayServicesAvailable(context: Context): Boolean {
        val googleApi = GoogleApiAvailability.getInstance()
        val result = googleApi.isGooglePlayServicesAvailable(context)
        return result == ConnectionResult.SUCCESS
    }
}