package org.findmykids.geo.common.logger

import android.annotation.SuppressLint
import android.content.Context
import io.reactivex.schedulers.Schedulers
import io.reactivex.subjects.PublishSubject
import java.io.File
import java.io.FileOutputStream
import java.io.IOException
import java.io.OutputStreamWriter


internal object FileLogSaver {
    private val mLock = Any()
    private val mSubject: PublishSubject<String> = PublishSubject.create()
    private var mFileOutputStream: FileOutputStream? = null
    private var mOutputStreamWriter: OutputStreamWriter? = null


    override fun toString(): String = ""


    @SuppressLint("CheckResult")
    fun init(context: Context) {
        if (mOutputStreamWriter != null) {
            return
        }
        try {
            val directory = File(context.externalCacheDir!!.absolutePath + "/Logs")
            if (!directory.exists()) {
                directory.mkdirs()
            }
            val file = File(directory, "geo.log")
            if (!file.exists()) {
                file.createNewFile()
            }
            mFileOutputStream = FileOutputStream(file)
            mOutputStreamWriter = OutputStreamWriter(
                mFileOutputStream!!)
            mSubject
                .observeOn(Schedulers.newThread())
                .doOnTerminate {
                    try {
                        mOutputStreamWriter?.flush()
                        mOutputStreamWriter?.close()
                    } catch (e: IOException) {
                        e.printStackTrace()
                    } finally {
                        mOutputStreamWriter = null
                    }
                    try {
                        mFileOutputStream?.flush()
                        mFileOutputStream?.close()
                    } catch (e: IOException) {
                        e.printStackTrace()
                    } finally {
                        mFileOutputStream = null
                    }
                }
                .subscribe {
                    try {
                        synchronized(mLock) {
                            mOutputStreamWriter?.write(it)
                            mOutputStreamWriter?.flush()
                        }
                    } catch (e: IOException) {
                        e.printStackTrace()
                    }
                }
        } catch (e: IOException) {
            e.printStackTrace()
        }
    }

    fun save(tag: String, text: String) {
        mSubject.onNext("$tag $text\n")
    }
}