/*
 * Decompiled with CFR 0.152.
 */
package org.findmykids.geo.data.repository.live.timeout;

import android.os.HandlerThread;
import io.reactivex.Completable;
import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.findmykids.geo.common.GeoException;
import org.findmykids.geo.common.logger.Logger;
import org.findmykids.geo.data.model.Configuration;
import org.findmykids.geo.data.repository.live.timeout.TimeoutEvent;
import org.findmykids.geo.data.repository.live.timeout.TimeoutRepository;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000f\u001a\u00020\tH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/findmykids/geo/data/repository/live/timeout/TimeoutRepositoryImpl;", "Lorg/findmykids/geo/data/repository/live/timeout/TimeoutRepository;", "()V", "mCreateTime", "", "mRestartDisposable", "Lio/reactivex/disposables/Disposable;", "mTimerDisposable", "restart", "", "configuration", "Lorg/findmykids/geo/data/model/Configuration$TimeoutDataConfiguration;", "handlerThread", "Landroid/os/HandlerThread;", "start", "stop", "toString", "", "geo_release"})
public final class TimeoutRepositoryImpl
extends TimeoutRepository {
    private Disposable mTimerDisposable;
    private long mCreateTime = System.currentTimeMillis();
    private Disposable mRestartDisposable;

    @Override
    @NotNull
    public String toString() {
        return "";
    }

    @Override
    protected void start(@NotNull Configuration.TimeoutDataConfiguration configuration, @NotNull HandlerThread handlerThread) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)handlerThread, (String)"handlerThread");
        Logger.i$default(Logger.INSTANCE, null, 1, null).addArg(configuration).print();
        Disposable disposable = this.mRestartDisposable;
        if (disposable != null) {
            disposable.dispose();
        }
        this.mRestartDisposable = null;
        this.mTimerDisposable = Observable.interval((long)configuration.getDelay(), (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)Schedulers.newThread()).subscribe((Consumer)new Consumer<Long>(this){
            final /* synthetic */ TimeoutRepositoryImpl this$0;

            public final void accept(Long it) {
                Logger.INSTANCE.d("success").with(this.this$0).print();
                long workTime = System.currentTimeMillis() - TimeoutRepositoryImpl.access$getMCreateTime$p(this.this$0);
                TimeoutRepositoryImpl.access$sendEvent(this.this$0, new TimeoutEvent(workTime));
            }
            {
                this.this$0 = timeoutRepositoryImpl;
            }
        }, (Consumer)new Consumer<Throwable>(this, configuration, handlerThread){
            final /* synthetic */ TimeoutRepositoryImpl this$0;
            final /* synthetic */ Configuration.TimeoutDataConfiguration $configuration;
            final /* synthetic */ HandlerThread $handlerThread;

            public final void accept(Throwable throwable) {
                TimeoutRepositoryImpl.access$setMTimerDisposable$p(this.this$0, null);
                Throwable throwable2 = throwable;
                Intrinsics.checkExpressionValueIsNotNull((Object)throwable2, (String)"throwable");
                TimeoutRepositoryImpl.access$sendError(this.this$0, new GeoException.TimeoutStart(throwable2));
                TimeoutRepositoryImpl.access$restart(this.this$0, this.$configuration, this.$handlerThread);
            }
            {
                this.this$0 = timeoutRepositoryImpl;
                this.$configuration = timeoutDataConfiguration;
                this.$handlerThread = handlerThread;
            }
        });
    }

    @Override
    protected void stop() {
        Logger.i$default(Logger.INSTANCE, null, 1, null).print();
        Disposable disposable = this.mTimerDisposable;
        if (disposable != null) {
            disposable.dispose();
        }
        this.mTimerDisposable = null;
        Disposable disposable2 = this.mRestartDisposable;
        if (disposable2 != null) {
            disposable2.dispose();
        }
        this.mRestartDisposable = null;
    }

    private final void restart(Configuration.TimeoutDataConfiguration configuration, HandlerThread handlerThread) {
        Logger.d$default(Logger.INSTANCE, null, 1, null).print();
        this.mRestartDisposable = Completable.timer((long)configuration.getRestartDelay(), (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)Schedulers.newThread()).subscribe(new Action(this, configuration, handlerThread){
            final /* synthetic */ TimeoutRepositoryImpl this$0;
            final /* synthetic */ Configuration.TimeoutDataConfiguration $configuration;
            final /* synthetic */ HandlerThread $handlerThread;

            public final void run() {
                TimeoutRepositoryImpl.access$setMRestartDisposable$p(this.this$0, null);
                Logger.INSTANCE.d("restart").with(this.this$0).print();
                if (TimeoutRepositoryImpl.access$isStarted(this.this$0)) {
                    this.this$0.start(this.$configuration, this.$handlerThread);
                }
            }
            {
                this.this$0 = timeoutRepositoryImpl;
                this.$configuration = timeoutDataConfiguration;
                this.$handlerThread = handlerThread;
            }
        }, (Consumer)new Consumer<Throwable>(this, configuration, handlerThread){
            final /* synthetic */ TimeoutRepositoryImpl this$0;
            final /* synthetic */ Configuration.TimeoutDataConfiguration $configuration;
            final /* synthetic */ HandlerThread $handlerThread;

            public final void accept(Throwable it) {
                TimeoutRepositoryImpl.access$setMRestartDisposable$p(this.this$0, null);
                Throwable throwable = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it");
                TimeoutRepositoryImpl.access$sendError(this.this$0, new GeoException.TimeoutRestart(throwable));
                TimeoutRepositoryImpl.access$restart(this.this$0, this.$configuration, this.$handlerThread);
            }
            {
                this.this$0 = timeoutRepositoryImpl;
                this.$configuration = timeoutDataConfiguration;
                this.$handlerThread = handlerThread;
            }
        });
    }

    @Inject
    public TimeoutRepositoryImpl() {
    }

    public static final /* synthetic */ long access$getMCreateTime$p(TimeoutRepositoryImpl $this) {
        return $this.mCreateTime;
    }

    public static final /* synthetic */ void access$setMCreateTime$p(TimeoutRepositoryImpl $this, long l) {
        $this.mCreateTime = l;
    }

    public static final /* synthetic */ void access$sendEvent(TimeoutRepositoryImpl $this, TimeoutEvent t) {
        $this.sendEvent(t);
    }

    public static final /* synthetic */ Disposable access$getMTimerDisposable$p(TimeoutRepositoryImpl $this) {
        return $this.mTimerDisposable;
    }

    public static final /* synthetic */ void access$setMTimerDisposable$p(TimeoutRepositoryImpl $this, Disposable disposable) {
        $this.mTimerDisposable = disposable;
    }

    public static final /* synthetic */ void access$sendError(TimeoutRepositoryImpl $this, GeoException geoException) {
        $this.sendError(geoException);
    }

    public static final /* synthetic */ void access$restart(TimeoutRepositoryImpl $this, Configuration.TimeoutDataConfiguration configuration, HandlerThread handlerThread) {
        $this.restart(configuration, handlerThread);
    }

    public static final /* synthetic */ Disposable access$getMRestartDisposable$p(TimeoutRepositoryImpl $this) {
        return $this.mRestartDisposable;
    }

    public static final /* synthetic */ void access$setMRestartDisposable$p(TimeoutRepositoryImpl $this, Disposable disposable) {
        $this.mRestartDisposable = disposable;
    }

    public static final /* synthetic */ boolean access$isStarted(TimeoutRepositoryImpl $this) {
        return $this.isStarted();
    }
}

