/*
 * Decompiled with CFR 0.152.
 */
package org.findmykids.geo.common.di.session.module;

import android.content.Context;
import com.huawei.hms.location.ActivityIdentification;
import dagger.Module;
import dagger.Provides;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.findmykids.geo.common.di.session.SessionScope;
import org.findmykids.geo.common.logger.Logger;
import org.findmykids.geo.common.utils.ManufactureUtil;
import org.findmykids.geo.data.network.SocketClient;
import org.findmykids.geo.data.preferences.LocalPreferences;
import org.findmykids.geo.data.repository.live.activity.ActivityRepository;
import org.findmykids.geo.data.repository.live.activity.google.ActivityRepositoryGoogleImpl;
import org.findmykids.geo.data.repository.live.activity.huawei.ActivityRepositoryHuaweiImpl;
import org.findmykids.geo.data.repository.live.battery.BatteryRepository;
import org.findmykids.geo.data.repository.live.battery.BatteryRepositoryImpl;
import org.findmykids.geo.data.repository.live.gps.GpsRepository;
import org.findmykids.geo.data.repository.live.gps.GpsRepositoryImpl;
import org.findmykids.geo.data.repository.live.lbs.LbsRepository;
import org.findmykids.geo.data.repository.live.lbs.LbsRepositoryImpl;
import org.findmykids.geo.data.repository.live.location.LocationRepository;
import org.findmykids.geo.data.repository.live.location.LocationRepositoryImpl;
import org.findmykids.geo.data.repository.live.remote.RemoteRepository;
import org.findmykids.geo.data.repository.live.remote.RemoteRepositoryImpl;
import org.findmykids.geo.data.repository.live.sensors.SensorsRepository;
import org.findmykids.geo.data.repository.live.sensors.SensorsRepositoryImpl;
import org.findmykids.geo.data.repository.live.timeout.TimeoutRepository;
import org.findmykids.geo.data.repository.live.timeout.TimeoutRepositoryImpl;
import org.findmykids.geo.data.repository.live.wifi.WifiRepository;
import org.findmykids.geo.data.repository.live.wifi.WifiRepositoryImpl;
import org.findmykids.geo.data.repository.storage.currentSession.CurrentSessionRepository;
import org.jetbrains.annotations.NotNull;

@Module
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0007J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0019\u001a\u00020\u001aH\u0007J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006\u001d"}, d2={"Lorg/findmykids/geo/common/di/session/module/DataLiveModule;", "", "()V", "provideActivityRepository", "Lorg/findmykids/geo/data/repository/live/activity/ActivityRepository;", "context", "Landroid/content/Context;", "provideBatteryRepository", "Lorg/findmykids/geo/data/repository/live/battery/BatteryRepository;", "provideGpsRepository", "Lorg/findmykids/geo/data/repository/live/gps/GpsRepository;", "provideLbsRepository", "Lorg/findmykids/geo/data/repository/live/lbs/LbsRepository;", "localPreferences", "Lorg/findmykids/geo/data/preferences/LocalPreferences;", "provideLocationRepository", "Lorg/findmykids/geo/data/repository/live/location/LocationRepository;", "provideRemoteRepository", "Lorg/findmykids/geo/data/repository/live/remote/RemoteRepository;", "socketClient", "Lorg/findmykids/geo/data/network/SocketClient;", "currentSessionRepository", "Lorg/findmykids/geo/data/repository/storage/currentSession/CurrentSessionRepository;", "provideSensorsRepository", "Lorg/findmykids/geo/data/repository/live/sensors/SensorsRepository;", "provideTimeoutRepository", "Lorg/findmykids/geo/data/repository/live/timeout/TimeoutRepository;", "provideWifiRepository", "Lorg/findmykids/geo/data/repository/live/wifi/WifiRepository;", "geo_release"})
public final class DataLiveModule {
    @Provides
    @SessionScope
    @NotNull
    public final ActivityRepository provideActivityRepository(@NotNull Context context) {
        ActivityRepository activityRepository;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (ManufactureUtil.INSTANCE.isHuawei() && ManufactureUtil.INSTANCE.isEmuiVersion9_1orAfter()) {
            ActivityRepository activityRepository2;
            try {
                if (ActivityIdentification.getService((Context)context) == null) {
                    Intrinsics.throwNpe();
                }
                activityRepository2 = new ActivityRepositoryHuaweiImpl(context);
            }
            catch (Exception e) {
                activityRepository2 = new ActivityRepositoryGoogleImpl(context);
            }
            activityRepository = activityRepository2;
        } else {
            activityRepository = new ActivityRepositoryGoogleImpl(context);
        }
        return activityRepository;
    }

    @Provides
    @SessionScope
    @NotNull
    public final BatteryRepository provideBatteryRepository(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new BatteryRepositoryImpl(context);
    }

    @Provides
    @SessionScope
    @NotNull
    public final GpsRepository provideGpsRepository(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new GpsRepositoryImpl(context);
    }

    @Provides
    @SessionScope
    @NotNull
    public final LbsRepository provideLbsRepository(@NotNull Context context, @NotNull LocalPreferences localPreferences) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)localPreferences, (String)"localPreferences");
        return new LbsRepositoryImpl(context, localPreferences);
    }

    @Provides
    @SessionScope
    @NotNull
    public final LocationRepository provideLocationRepository(@NotNull Context context, @NotNull LocalPreferences localPreferences) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)localPreferences, (String)"localPreferences");
        return new LocationRepositoryImpl(context, localPreferences);
    }

    @Provides
    @SessionScope
    @NotNull
    public final RemoteRepository provideRemoteRepository(@NotNull SocketClient socketClient, @NotNull Context context, @NotNull CurrentSessionRepository currentSessionRepository, @NotNull LocalPreferences localPreferences) {
        Intrinsics.checkParameterIsNotNull((Object)socketClient, (String)"socketClient");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)currentSessionRepository, (String)"currentSessionRepository");
        Intrinsics.checkParameterIsNotNull((Object)localPreferences, (String)"localPreferences");
        return new RemoteRepositoryImpl(socketClient, context, currentSessionRepository, localPreferences);
    }

    @Provides
    @SessionScope
    @NotNull
    public final SensorsRepository provideSensorsRepository(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new SensorsRepositoryImpl(context);
    }

    @Provides
    @SessionScope
    @NotNull
    public final TimeoutRepository provideTimeoutRepository() {
        return new TimeoutRepositoryImpl();
    }

    @Provides
    @SessionScope
    @NotNull
    public final WifiRepository provideWifiRepository(@NotNull Context context, @NotNull LocalPreferences localPreferences) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)localPreferences, (String)"localPreferences");
        return new WifiRepositoryImpl(context, localPreferences);
    }

    public DataLiveModule() {
        Logger.d$default(Logger.INSTANCE, null, 1, null).print();
    }
}

