package org.findmykids.geo.domain.model

import org.findmykids.geo._todo.Geo
import org.findmykids.geo.data.model.Configurations
import org.findmykids.geo.data.model.Error
import org.findmykids.geo.data.model.GeoLocation
import org.findmykids.geo.data.model.Zones


/**
 * События от лайв обработчиков
 */
internal sealed class InnerEvent {
    /**
     * Гео
     */
    //TODO яндекс
    class NewGeo(
        val geo: Geo
    ) : InnerEvent() {
        override fun toString(): String {
            return "${this::class.simpleName}(" +
                    "${this::class.java.declaredFields[0].name}=$geo)"
        }
    }

    /**
     * Ошибка
     */
    class NewError(
        val error: Error
    ) : InnerEvent() {
        override fun toString(): String {
            return "${this::class.simpleName}(" +
                    "${this::class.java.declaredFields[0].name}=$error)"
        }
    }

    /**
     * Геолокация
     */
    class NewGeoLocation(
        val geoLocation: GeoLocation
    ) : InnerEvent() {
        override fun toString(): String {
            return "${this::class.simpleName}(" +
                    "${this::class.java.declaredFields[0].name}=$geoLocation)"
        }
    }

    /**
     * Зона безопасности
     */
    // TODO Зоны безопасности
    class NewZones(
        val zones: Zones
    ) : InnerEvent() {
        override fun toString(): String {
            return "${this::class.simpleName}(" +
                    "${this::class.java.declaredFields[0].name}=$zones)"
        }
    }

    /**
     * Конфигурация
     */
    class NewConfigurations(
        private val configurations: Configurations
    ) : InnerEvent() {
        override fun toString(): String {
            return "${this::class.simpleName}(" +
                    "${this::class.java.declaredFields[0].name}=$configurations)"
        }
    }

    /**
     * Закрытие сессии
     */
    class EndCurrentSession(
        private val reason: EndSessionReason
    ) : InnerEvent() {
        override fun toString(): String {
            return "${this::class.simpleName}(" +
                    "${this::class.java.declaredFields[0].name}=$reason)"
        }


        sealed class EndSessionReason {
            object Stop : EndSessionReason() {
                override fun toString(): String {
                    return this::class.simpleName!!
                }
            }

            object Timeout : EndSessionReason() {
                override fun toString(): String {
                    return this::class.simpleName!!
                }
            }

            object Fused : EndSessionReason() {
                override fun toString(): String {
                    return this::class.simpleName!!
                }
            }


            override fun toString(): String = ""
        }
    }

    /**
     * Остановка
     */
    object Stop : InnerEvent() {
        override fun toString(): String {
            return "${this::class.simpleName}()"
        }
    }


    override fun toString(): String = ""
}