package org.findmykids.geo.data.repository.trigger.zones

import android.app.job.JobInfo
import android.app.job.JobScheduler
import android.content.BroadcastReceiver
import android.content.ComponentName
import android.content.Context
import android.content.Intent
import android.os.Build
import android.os.PersistableBundle
import androidx.core.content.ContextCompat.getSystemService
import com.google.gson.Gson
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.data.model.ZoneEvent
import org.findmykids.geo.presentation.session.SessionService
import java.util.concurrent.TimeUnit


// TODO Зоны безопасности
internal abstract class BaseZonesReceiver : BroadcastReceiver() {
    fun send(context: Context, zoneEvent: ZoneEvent) {
        val textZoneEvent = Gson().toJson(zoneEvent)
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            val extras = PersistableBundle().apply {
                putString(EXTRA_ZONE_EVENT, textZoneEvent)
            }
            val jobInfo = JobInfo
                .Builder(ZonesJobSchedulerService.JOB_ID, ComponentName(context, ZonesJobSchedulerService::class.java))
                .setOverrideDeadline(TimeUnit.SECONDS.toMillis(5))
                .setExtras(extras)
                .build()
            val jobScheduler = getSystemService(context, JobScheduler::class.java)
            jobScheduler?.let {
                Logger.d("job scheduled").with(this@BaseZonesReceiver).print()
                it.schedule(jobInfo)
            }
        } else {
            val actionIntent = Intent(context, SessionService::class.java)
            actionIntent.action = ACTION_ZONE
            actionIntent.putExtra(EXTRA_ZONE_EVENT, textZoneEvent)
            context.startService(actionIntent)
        }
    }


    companion object {
        const val ACTION_ZONE = "ACTION_ZONE"
        const val EXTRA_ZONE_EVENT = "EXTRA_ZONE_EVENT"
    }
}