package org.findmykids.geo.data.repository.trigger.timer.alarm

import android.app.job.JobInfo
import android.app.job.JobScheduler
import android.content.BroadcastReceiver
import android.content.ComponentName
import android.content.Context
import android.content.Intent
import android.os.Build
import androidx.core.content.ContextCompat.getSystemService
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.presentation.session.SessionService
import java.util.concurrent.TimeUnit


internal class AlarmManagerReceiver : BroadcastReceiver() {
    override fun onReceive(context: Context, intent: Intent) {
        Logger.d().print()
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            val jobInfo = JobInfo
                .Builder(AlarmJobSchedulerService.JOB_ID, ComponentName(context, AlarmJobSchedulerService::class.java))
                .setOverrideDeadline(TimeUnit.SECONDS.toMillis(5))
                .setRequiredNetworkType(JobInfo.NETWORK_TYPE_ANY)
                .build()
            val jobScheduler = getSystemService(context, JobScheduler::class.java)
            jobScheduler?.let {
                Logger.d("job scheduled").with(this@AlarmManagerReceiver).print()
                it.schedule(jobInfo)
            }
        } else {
            val actionIntent = Intent(context, SessionService::class.java)
            actionIntent.action = ACTION_TIMER_ALARM
            context.startService(actionIntent)
        }
    }


    companion object {
        const val ACTION_TIMER_ALARM = "ACTION_TIMER_ALARM"
    }
}