package org.findmykids.geo.data.repository.trigger.activity.google

import android.content.Context
import android.content.Intent
import com.google.android.gms.location.ActivityTransitionResult
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.data.repository.trigger.activity.ActivityEventFactory
import org.findmykids.geo.data.repository.trigger.activity.BaseActivityReceiver


internal class ActivityGoogleReceiver : BaseActivityReceiver() {
    override fun onReceive(context: Context, intent: Intent) {
        Logger.d().print()
        val results = ActivityTransitionResult.extractResult(intent)
        val events = results?.transitionEvents
        if (events != null && events.isNotEmpty()) {
            Logger.d().addArg(events).with(this@ActivityGoogleReceiver).print()
            send(context, ActivityEventFactory.createFromTransition(events))
        }
    }
}