package org.findmykids.geo.data.repository.storage.geo

import org.findmykids.geo.data.db.model.SendGeoLocationEntity
import org.findmykids.geo.data.model.*


internal object SendGeoLocationFactory {
    fun create(geoLocation: GeoLocation, sendReason: String, sendIndex: Long, globalSendIndex: Long) =
        SendGeoLocation(
            geoLocation.create,
            geoLocation.session,
            geoLocation.location,
            geoLocation.locationDefineSessionIndex,
            geoLocation.locationDefineGlobalIndex,
            geoLocation.calculatedLocation,
            geoLocation.gpsInfo,
            geoLocation.activity,
            geoLocation.battery,
            geoLocation.wifi,
            sendReason,
            sendIndex,
            globalSendIndex,
            geoLocation.extensions.toMutableMap()
        )

    fun create(sendGeoLocationEntity: SendGeoLocationEntity) = SendGeoLocation(
        sendGeoLocationEntity.create,
        Session(
            sendGeoLocationEntity.sessionIndex,
            sendGeoLocationEntity.sessionCreate,
            sendGeoLocationEntity.sessionIsRealtime,
            sendGeoLocationEntity.sessionCommandsTypes
        ),
        Location(
            sendGeoLocationEntity.locationLatitude,
            sendGeoLocationEntity.locationLongitude,
            sendGeoLocationEntity.locationProvider,
            sendGeoLocationEntity.locationTime,
            sendGeoLocationEntity.locationAltitude,
            sendGeoLocationEntity.locationAccuracy,
            sendGeoLocationEntity.locationBearing,
            sendGeoLocationEntity.locationElapsedRealtimeUncertaintyNanos,
            sendGeoLocationEntity.locationSpeed,
            sendGeoLocationEntity.locationSpeedAccuracyMetersPerSecond,
            sendGeoLocationEntity.locationVerticalAccuracyMeters,
            sendGeoLocationEntity.locationBearingAccuracyDegrees,
            sendGeoLocationEntity.locationElapsedRealtimeNanos,
            sendGeoLocationEntity.locationSource
        ),
        sendGeoLocationEntity.locationDefineSessionIndex,
        sendGeoLocationEntity.locationDefineGlobalIndex,
        if (sendGeoLocationEntity.calculatedLocationExist) {
            CalculatedLocation(
                sendGeoLocationEntity.calculatedLocationLatitude!!,
                sendGeoLocationEntity.calculatedLocationLongitude!!,
                sendGeoLocationEntity.calculatedLocationAltitude!!,
                sendGeoLocationEntity.calculatedLocationSpeed!!
            )
        } else {
            null
        },
        if (sendGeoLocationEntity.gpsInfoExist) {
            GpsInfo(
                sendGeoLocationEntity.gpsInfoTimeToFirstFix!!,
                sendGeoLocationEntity.gpsInfoMaxSatellites!!,
                sendGeoLocationEntity.gpsInfoSatellites!!
            )
        } else {
            null
        },
        if (sendGeoLocationEntity.activityExist) {
            Activity(
                sendGeoLocationEntity.activityElapsedRealtimeMillis!!,
                sendGeoLocationEntity.activityTime!!,
                sendGeoLocationEntity.activityActivitiesWithConfidences!!
            )
        } else {
            null
        },
        if (sendGeoLocationEntity.batteryExist) {
            Battery(
                sendGeoLocationEntity.batteryIsCharging!!,
                sendGeoLocationEntity.batteryLevel!!
            )
        } else {
            null
        },
        if (sendGeoLocationEntity.wifiExist) {
            Wifi(
                sendGeoLocationEntity.wifiSsid!!,
                sendGeoLocationEntity.wifiMac!!,
                sendGeoLocationEntity.wifiLevel!!
            )
        } else {
            null
        },
        sendGeoLocationEntity.sendReason,
        sendGeoLocationEntity.sendSessionIndex,
        sendGeoLocationEntity.sendGlobalIndex,
        sendGeoLocationEntity.extensions.toMutableMap()
    )
}