@file:Suppress("DEPRECATION")

package org.findmykids.geo.data.repository.live.gps

import android.location.GnssStatus
import android.location.GpsStatus
import android.os.Build
import androidx.annotation.RequiresApi
import org.findmykids.geo.data.model.GpsInfo


internal object GpsInfoFactory {
    @RequiresApi(Build.VERSION_CODES.N)
    fun createFromGnssStatus(gnssStatus: GnssStatus): GpsInfo {
        val satellites = mutableListOf<GpsInfo.SatelliteInfo>()
        for (i in 0 until gnssStatus.satelliteCount) {
            satellites.add(
                GpsInfo.SatelliteInfo(
                    gnssStatus.getConstellationType(i),
                    gnssStatus.hasEphemerisData(i),
                    gnssStatus.hasAlmanacData(i),
                    gnssStatus.usedInFix(i),
                    gnssStatus.getSvid(i),
                    gnssStatus.getCn0DbHz(i),
                    gnssStatus.getElevationDegrees(i),
                    gnssStatus.getAzimuthDegrees(i)
                )
            )
        }
        return GpsInfo(
            0,
            -1,
            satellites
        )
    }

    fun createFromGpsStatus(gpsStatus: GpsStatus): GpsInfo =
        GpsInfo(
            gpsStatus.timeToFirstFix,
            gpsStatus.maxSatellites,
            gpsStatus.satellites.map {
                GpsInfo.SatelliteInfo(
                    1,
                    it.hasEphemeris(),
                    it.hasAlmanac(),
                    it.usedInFix(),
                    it.prn,
                    it.snr,
                    it.elevation,
                    it.azimuth
                )
            }
        )
}