package org.findmykids.geo.data.repository.live.battery

import android.content.Intent
import android.os.BatteryManager
import org.findmykids.geo.data.model.Battery


internal object BatteryFactory {
    fun create(intent: Intent): Battery {
        val level = intent.getIntExtra(BatteryManager.EXTRA_LEVEL, -1)
        val scale = intent.getIntExtra(BatteryManager.EXTRA_SCALE, -1)
        val status = intent.getIntExtra(BatteryManager.EXTRA_STATUS, -1)
        return Battery(
            (status == BatteryManager.BATTERY_STATUS_CHARGING || status == BatteryManager.BATTERY_STATUS_FULL),
            if (level == -1 || scale == -1) 0 else (level.toFloat() / scale.toFloat() * 100.0f).toInt()
        )
    }
}