package org.findmykids.geo.data.model


data class GpsInfo(
    val timeToFirstFix: Int,
    val maxSatellites: Int,
    val satellites: List<SatelliteInfo>
) {
    override fun toString(): String {
        return "${this::class.simpleName}(" +
                "${this::class.java.declaredFields[2].name}=$timeToFirstFix, " +
                "${this::class.java.declaredFields[0].name}=$maxSatellites, " +
                "${this::class.java.declaredFields[1].name}=$satellites)"
    }


    fun getUsedSatellitesCount() = satellites.filter { it.usedInFix }.size


    data class SatelliteInfo(
        val type: Int,
        val hasEphemeris: Boolean,
        val hasAlmanac: Boolean,
        val usedInFix: Boolean,
        val prn: Int,
        val snr: Float,
        val elevation: Float,
        val azimuth: Float
    ) {
        override fun toString(): String {
            return "${this::class.simpleName}(" +
                    "${this::class.java.declaredFields[6].name}=$type, " +
                    "${this::class.java.declaredFields[3].name}=$hasEphemeris, " +
                    "${this::class.java.declaredFields[2].name}=$hasAlmanac, " +
                    "${this::class.java.declaredFields[7].name}=$usedInFix, " +
                    "${this::class.java.declaredFields[4].name}=$prn, " +
                    "${this::class.java.declaredFields[5].name}=$snr, " +
                    "${this::class.java.declaredFields[1].name}=$elevation, " +
                    "${this::class.java.declaredFields[0].name}=$azimuth)"
        }
    }
}