package org.findmykids.geo.data.db.factory

import org.findmykids.geo.data.db.model.SendGeoLocationEntity
import org.findmykids.geo.data.model.SendGeoLocation


internal object SendGeoLocationEntityFactory {
    fun create(sendGeoLocation: SendGeoLocation) = SendGeoLocationEntity(
        create = sendGeoLocation.create,
        sessionIndex = sendGeoLocation.session.index,
        sessionCreate = sendGeoLocation.session.create,
        sessionIsRealtime = sendGeoLocation.session.isRealtime,
        sessionCommandsTypes = sendGeoLocation.session.commandsTypes,
        locationLatitude = sendGeoLocation.location.latitude,
        locationLongitude = sendGeoLocation.location.longitude,
        locationProvider = sendGeoLocation.location.provider,
        locationTime = sendGeoLocation.location.time,
        locationAltitude = sendGeoLocation.location.altitude,
        locationAccuracy = sendGeoLocation.location.accuracy,
        locationBearing = sendGeoLocation.location.bearing,
        locationElapsedRealtimeUncertaintyNanos = sendGeoLocation.location.elapsedRealtimeUncertaintyNanos,
        locationSpeed = sendGeoLocation.location.speed,
        locationSpeedAccuracyMetersPerSecond = sendGeoLocation.location.speedAccuracyMetersPerSecond,
        locationVerticalAccuracyMeters = sendGeoLocation.location.verticalAccuracyMeters,
        locationBearingAccuracyDegrees = sendGeoLocation.location.bearingAccuracyDegrees,
        locationElapsedRealtimeNanos = sendGeoLocation.location.elapsedRealtimeNanos,
        locationSource = sendGeoLocation.location.source,
        locationDefineSessionIndex = sendGeoLocation.locationDefineSessionIndex,
        locationDefineGlobalIndex = sendGeoLocation.locationDefineGlobalIndex,
        calculatedLocationExist = sendGeoLocation.calculatedLocation != null,
        calculatedLocationLatitude = sendGeoLocation.calculatedLocation?.latitude,
        calculatedLocationLongitude = sendGeoLocation.calculatedLocation?.longitude,
        calculatedLocationAltitude = sendGeoLocation.calculatedLocation?.altitude,
        calculatedLocationSpeed = sendGeoLocation.calculatedLocation?.speed,
        gpsInfoExist = sendGeoLocation.gpsInfo != null,
        gpsInfoTimeToFirstFix = sendGeoLocation.gpsInfo?.timeToFirstFix,
        gpsInfoMaxSatellites = sendGeoLocation.gpsInfo?.maxSatellites,
        gpsInfoSatellites = sendGeoLocation.gpsInfo?.satellites,
        activityExist = sendGeoLocation.activity != null,
        activityElapsedRealtimeMillis = sendGeoLocation.activity?.elapsedRealtimeMillis,
        activityTime = sendGeoLocation.activity?.time,
        activityActivitiesWithConfidences = sendGeoLocation.activity?.activitiesWithConfidences,
        batteryExist = sendGeoLocation.battery != null,
        batteryIsCharging = sendGeoLocation.battery?.isCharging,
        batteryLevel = sendGeoLocation.battery?.level,
        wifiExist = sendGeoLocation.wifi != null,
        wifiSsid = sendGeoLocation.wifi?.ssid,
        wifiMac = sendGeoLocation.wifi?.mac,
        wifiLevel = sendGeoLocation.wifi?.level,
        sendReason = sendGeoLocation.sendReason,
        sendSessionIndex = sendGeoLocation.sendSessionIndex,
        sendGlobalIndex = sendGeoLocation.sendGlobalIndex,
        extensions = sendGeoLocation.extensions
    )
}