package org.findmykids.geo.data.db.dao

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.Query
import org.findmykids.geo.data.db.model.ZoneEntity


@Dao
internal interface ZonesDao {
    @Query("SELECT * FROM ZoneEntity")
    fun selectAll(): List<ZoneEntity>

    @Insert(onConflict = OnConflictStrategy.ABORT)
    fun insert(zoneEntity: ZoneEntity)

    @Query("DELETE FROM ZoneEntity")
    fun deleteAll()
}